/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Permission;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PermissionJSONImpl
implements Permission,
Serializable {
    private static final long serialVersionUID = -3507159691486381813L;
    private String name;
    private boolean isGranted;

    private PermissionJSONImpl(String name, boolean isGranted) {
        this.name = name;
        this.isGranted = isGranted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isGranted() {
        return this.isGranted;
    }

    static List<Permission> createPermissionArray(HttpResponse res, Configuration conf) throws FacebookException {
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        JSONObject json = res.asJSONObject();
        try {
            JSONArray list = json.getJSONArray("data");
            for (int i = 0; i < list.length(); ++i) {
                JSONObject permissionJSONObject = list.getJSONObject(i);
                String permissionName = permissionJSONObject.getString("permission");
                boolean isGranted = "granted".equalsIgnoreCase(permissionJSONObject.getString("status"));
                permissions.add(new PermissionJSONImpl(permissionName, isGranted));
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(permissions, list);
            }
            return permissions;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isGranted ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PermissionJSONImpl other = (PermissionJSONImpl)obj;
        if (this.isGranted != other.isGranted) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "PermissionJSONImpl [name=" + this.name + ", isGranted=" + this.isGranted + "]";
    }
}

