/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Movie;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MovieJSONImpl
extends CategoryJSONImpl
implements Movie,
Serializable {
    private static final long serialVersionUID = -2806942430895417046L;

    MovieJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
    }

    MovieJSONImpl(JSONObject json) throws FacebookException {
        super(json);
    }

    static ResponseList<Movie> createMovieList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Movie> movies = new ResponseListImpl<Movie>(size, json, new Movie[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject movieJSONObject = list.getJSONObject(i);
                MovieJSONImpl movie = new MovieJSONImpl(movieJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(movie, movieJSONObject);
                }
                movies.add(movie);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(movies, list);
            }
            return movies;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String toString() {
        return "MovieJSONImpl [id=" + this.id + ", name=" + this.name + ", category=" + this.category + ", createdTime=" + this.createdTime + "]";
    }
}

