/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Like;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LikeJSONImpl
extends CategoryJSONImpl
implements Like,
Serializable {
    private static final long serialVersionUID = 408717416922539206L;

    LikeJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
    }

    LikeJSONImpl(JSONObject json) throws FacebookException {
        super(json);
    }

    static ResponseList<Like> createLikeList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Like> likes = new ResponseListImpl<Like>(size, json, new Like[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject likeJSONObject = list.getJSONObject(i);
                LikeJSONImpl like = new LikeJSONImpl(likeJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(like, likeJSONObject);
                }
                likes.add(like);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(likes, list);
            }
            return likes;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String toString() {
        return "LikeJSONImpl [id=" + this.id + ", name=" + this.name + ", category=" + this.category + ", createdTime=" + this.createdTime + "]";
    }
}

