/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Game;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GameJSONImpl
extends CategoryJSONImpl
implements Game,
Serializable {
    private static final long serialVersionUID = 6796783238460639667L;

    GameJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
    }

    GameJSONImpl(JSONObject json) throws FacebookException {
        super(json);
    }

    static ResponseList<Game> createGameList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Game> games = new ResponseListImpl<Game>(size, json, new Game[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject gameJSONObject = list.getJSONObject(i);
                GameJSONImpl game = new GameJSONImpl(gameJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(game, gameJSONObject);
                }
                games.add(game);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(games, list);
            }
            return games;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String toString() {
        return "GameJSONImpl [id=" + this.id + ", name=" + this.name + ", category=" + this.category + ", createdTime=" + this.createdTime + "]";
    }
}

