/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.ResponseList;
import facebook4j.TestUser;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestUserJSONImpl
implements TestUser,
Serializable {
    private static final long serialVersionUID = -5704997286478031118L;
    private String id;
    private String accessToken;
    private String loginUrl;
    private String email;
    private String password;

    TestUserJSONImpl(HttpResponse res) throws FacebookException {
        JSONObject json = res.asJSONObject();
        this.init(json);
    }

    TestUserJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    static ResponseList<TestUser> createTestUserList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<TestUser> testUsers = new ResponseListImpl<TestUser>(size, json, new TestUser[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject testUserJSONObject = list.getJSONObject(i);
                TestUserJSONImpl testUser = new TestUserJSONImpl(testUserJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(testUser, testUserJSONObject);
                }
                testUsers.add(testUser);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(testUsers, list);
            }
            return testUsers;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    private void init(JSONObject json) throws FacebookException {
        this.id = z_F4JInternalParseUtil.getRawString("id", json);
        this.accessToken = z_F4JInternalParseUtil.getRawString("access_token", json);
        this.loginUrl = z_F4JInternalParseUtil.getRawString("login_url", json);
        if (!json.isNull("email")) {
            this.email = z_F4JInternalParseUtil.getRawString("email", json);
        }
        if (!json.isNull("password")) {
            this.password = z_F4JInternalParseUtil.getRawString("password", json);
        }
    }

    @Override
    public int compareTo(TestUser that) {
        return this.id.compareTo(that.getId());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getLoginUrl() {
        return this.loginUrl;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestUserJSONImpl other = (TestUserJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "TestUserJSONImpl [id=" + this.id + ", accessToken=" + this.accessToken + ", loginUrl=" + this.loginUrl + ", email=" + this.email + ", password=" + this.password + "]";
    }
}

