/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Picture;
import facebook4j.ResponseList;
import facebook4j.TaggableFriend;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.PictureJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TaggableFriendJSONImpl
extends FacebookResponseImpl
implements TaggableFriend,
Serializable {
    private static final long serialVersionUID = 181026591648082420L;
    private String token;
    private String name;
    private Picture picture;

    TaggableFriendJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    TaggableFriendJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.token = z_F4JInternalParseUtil.getRawString("id", json);
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            if (!json.isNull("picture")) {
                String pictureRawString = z_F4JInternalParseUtil.getRawString("picture", json);
                if (pictureRawString.startsWith("{")) {
                    JSONObject pictureJSONObject = json.getJSONObject("picture");
                    this.picture = new PictureJSONImpl(pictureJSONObject);
                } else {
                    this.picture = new PictureJSONImpl(z_F4JInternalParseUtil.getURL("picture", json));
                }
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Picture getPicture() {
        return this.picture;
    }

    static ResponseList<TaggableFriend> createTaggableFriendList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<TaggableFriend> friends = new ResponseListImpl<TaggableFriend>(size, json, new TaggableFriend[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject friendJSONObject = list.getJSONObject(i);
                TaggableFriendJSONImpl friend = new TaggableFriendJSONImpl(friendJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(friend, friendJSONObject);
                }
                friends.add(friend);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(friends, list);
            }
            return friends;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaggableFriendJSONImpl)) {
            return false;
        }
        return obj instanceof TaggableFriend && ((TaggableFriend)obj).getToken().equals(this.token);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public String toString() {
        return "TaggableFriendJSONImpl{id=" + this.token + "name=" + this.name + ", picture=" + this.picture + '}';
    }
}

