/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Category;
import facebook4j.FacebookException;
import facebook4j.Offer;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OfferJSONImpl
extends FacebookResponseImpl
implements Offer,
Serializable {
    private static final long serialVersionUID = -1552332355107913815L;
    private String id;
    private Category from;
    private String title;
    private Date createdTime;
    private Date expirationTime;
    private String terms;
    private URL imageURL;
    private Integer claimLimit;
    private String couponType;
    private URL redemptionLink;
    private String redemptionCode;
    private Boolean isPublished;
    private Integer scheduledPublishTime;
    private Date reminderTime;

    OfferJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    OfferJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new CategoryJSONImpl(fromJSONObject);
            }
            this.title = z_F4JInternalParseUtil.getRawString("title", json);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.expirationTime = z_F4JInternalParseUtil.getISO8601Datetime("expiration_time", json);
            this.terms = z_F4JInternalParseUtil.getRawString("terms", json);
            this.imageURL = z_F4JInternalParseUtil.getURL("image_url", json);
            this.claimLimit = z_F4JInternalParseUtil.getInt("claim_limit", json);
            this.couponType = z_F4JInternalParseUtil.getRawString("coupon_type", json);
            this.redemptionLink = z_F4JInternalParseUtil.getURL("redemption_link", json);
            this.redemptionCode = z_F4JInternalParseUtil.getRawString("redemption_code", json);
            this.isPublished = z_F4JInternalParseUtil.getBoolean("published", json);
            this.scheduledPublishTime = z_F4JInternalParseUtil.getInt("scheduled_publish_time", json);
            this.reminderTime = z_F4JInternalParseUtil.getISO8601Datetime("reminder_time", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public String getTerms() {
        return this.terms;
    }

    @Override
    public URL getImageURL() {
        return this.imageURL;
    }

    @Override
    public Integer getClaimLimit() {
        return this.claimLimit;
    }

    @Override
    public String getCouponType() {
        return this.couponType;
    }

    @Override
    public URL getRedemptionLink() {
        return this.redemptionLink;
    }

    @Override
    public String getRedemptionCode() {
        return this.redemptionCode;
    }

    @Override
    public Boolean isPublished() {
        return this.isPublished;
    }

    @Override
    public Integer getScheduledPublishTime() {
        return this.scheduledPublishTime;
    }

    @Override
    public Date getReminderTime() {
        return this.reminderTime;
    }

    static ResponseList<Offer> createOfferList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Offer> offers = new ResponseListImpl<Offer>(size, json, new Offer[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject offerJSONObject = list.getJSONObject(i);
                OfferJSONImpl offer = new OfferJSONImpl(offerJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(offer, offerJSONObject);
                }
                offers.add(offer);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(offers, list);
            }
            return offers;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OfferJSONImpl)) {
            return false;
        }
        OfferJSONImpl offerJSON = (OfferJSONImpl)o;
        return !(this.id != null ? !this.id.equals(offerJSON.id) : offerJSON.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "OfferJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", title='" + this.title + '\'' + ", createdTime=" + this.createdTime + ", expirationTime=" + this.expirationTime + ", terms='" + this.terms + '\'' + ", imageURL=" + this.imageURL + ", claimLimit=" + this.claimLimit + ", couponType='" + this.couponType + '\'' + ", redemptionLink=" + this.redemptionLink + ", redemptionCode='" + this.redemptionCode + '\'' + ", isPublished=" + this.isPublished + ", scheduledPublishTime=" + this.scheduledPublishTime + ", reminderTime=" + this.reminderTime + '}';
    }
}

