/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Application;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.Location;
import facebook4j.PagableList;
import facebook4j.Place;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.ApplicationJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.PlaceJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocationJSONImpl
extends FacebookResponseImpl
implements Location,
Serializable {
    private static final long serialVersionUID = -5585291369443446494L;
    private String id;
    private IdNameEntity from;
    private PagableList<IdNameEntity> tags;
    private Place place;
    private Application application;
    private Date createdTime;
    private String type;

    LocationJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    LocationJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            if (!json.isNull("tags")) {
                JSONObject tagsJSONObject = json.getJSONObject("tags");
                JSONArray list = tagsJSONObject.getJSONArray("data");
                int size = list.length();
                this.tags = new PagableListImpl<IdNameEntity>(size, tagsJSONObject, new IdNameEntity[0]);
                for (int i = 0; i < size; ++i) {
                    IdNameEntityJSONImpl tag = new IdNameEntityJSONImpl(list.getJSONObject(i));
                    this.tags.add(tag);
                }
            } else {
                this.tags = new PagableListImpl<IdNameEntity>(0);
            }
            if (!json.isNull("place")) {
                JSONObject placeJSONObject = json.getJSONObject("place");
                this.place = new PlaceJSONImpl(placeJSONObject);
            }
            if (!json.isNull("application")) {
                JSONObject applicationJSONObject = json.getJSONObject("application");
                this.application = new ApplicationJSONImpl(applicationJSONObject);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.type = z_F4JInternalParseUtil.getRawString("type", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public PagableList<IdNameEntity> getTags() {
        return this.tags;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getType() {
        return this.type;
    }

    static ResponseList<Location> createLocationList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Location> locations = new ResponseListImpl<Location>(size, json, new Location[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject locationJSONObject = list.getJSONObject(i);
                LocationJSONImpl location = new LocationJSONImpl(locationJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(location, locationJSONObject);
                }
                locations.add(location);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(locations, list);
            }
            return locations;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationJSONImpl other = (LocationJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "LocationJSONImpl [id=" + this.id + ", from=" + this.from + ", tags=" + this.tags + ", place=" + this.place + ", application=" + this.application + ", createdTime=" + this.createdTime + ", type=" + this.type + "]";
    }
}

