/*
 * Copyright 2012 Ryuji Yamashita
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package facebook4j;

/**
 * An enum represents the reaction types.
 * @author Ryuji Yamashita - roundrop at gmail.com
 * @since 2.4.4
 */
public enum ReactionType {
    NONE,
    LIKE,
    LOVE,
    WOW,
    HAHA,
    SAD,
    ANGRY,
    THANKFUL,
    ;
    
    public static ReactionType of(String reactionTypeString) {
        if (reactionTypeString == null) {
            return null;
        }
        if (reactionTypeString.equals("")) {
            return ReactionType.NONE;
        }
        for (ReactionType reactionType : ReactionType.values()) {
            if (reactionType.toString().equals(reactionTypeString.toUpperCase())) {
                return reactionType;
            }
        }
        return null;
    }
}
