/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.InboxResponseList;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InboxResponseListImpl<T>
extends ResponseListImpl<T>
implements InboxResponseList<T> {
    private static final long serialVersionUID = -392100352680662139L;
    private InboxResponseList.InboxSummary inboxSummary;

    InboxResponseListImpl(JSONObject json, T ... t) throws FacebookException {
        super(json, t);
        this.init(json);
    }

    InboxResponseListImpl(int size, JSONObject json, T ... t) throws FacebookException {
        super(size, json, t);
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            if (!json.isNull("summary")) {
                JSONObject summaryJSONObject = json.getJSONObject("summary");
                this.inboxSummary = new InboxSummaryJSONImpl(summaryJSONObject);
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public InboxResponseList.InboxSummary getInboxSummary() {
        return this.inboxSummary;
    }

    @Override
    public String toString() {
        return "InboxResponseListImpl [summary=" + this.inboxSummary + "]";
    }

    private class InboxSummaryJSONImpl
    implements InboxResponseList.InboxSummary,
    Serializable {
        private static final long serialVersionUID = 1988071486977638655L;
        private Integer unseenCount;
        private Integer unreadCount;
        private Date updatedTime;

        public InboxSummaryJSONImpl(JSONObject json) throws FacebookException {
            if (!json.isNull("unseen_count")) {
                this.unseenCount = z_F4JInternalParseUtil.getPrimitiveInt("unseen_count", json);
            }
            if (!json.isNull("unread_count")) {
                this.unreadCount = z_F4JInternalParseUtil.getPrimitiveInt("unread_count", json);
            }
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
        }

        public Integer getUnseenCount() {
            return this.unseenCount;
        }

        public Integer getUnreadCount() {
            return this.unreadCount;
        }

        public Date getUpdatedTime() {
            return this.updatedTime;
        }

        public String toString() {
            return "SummaryJSONImpl [unseenCount=" + this.unseenCount + ", unreadCount=" + this.unreadCount + ", updatedTime=" + this.updatedTime + "]";
        }
    }
}

