/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Reaction;
import facebook4j.ReactionType;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactionJSONImpl
extends CategoryJSONImpl
implements Reaction,
Serializable {
    private static final long serialVersionUID = 4813956293820850547L;
    private ReactionType type;

    ReactionJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
        this.init(res.asJSONObject());
    }

    ReactionJSONImpl(JSONObject json) throws FacebookException {
        super(json);
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        this.type = ReactionType.of(z_F4JInternalParseUtil.getRawString("type", json));
    }

    public static ResponseList<Reaction> createReactionsList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            JSONObject json;
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            if ((json = res.asJSONObject()).has("reactions")) {
                json = json.getJSONObject("reactions");
            }
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Reaction> reactions = new ResponseListImpl<Reaction>(size, json, new Reaction[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject reactionJSONObject = list.getJSONObject(i);
                ReactionJSONImpl reaction = new ReactionJSONImpl(reactionJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(reaction, reactionJSONObject);
                }
                reactions.add(reaction);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(reactions, list);
            }
            return reactions;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
        catch (FacebookException e) {
            throw new FacebookException(e.getMessage());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ReactionType getType() {
        return this.type;
    }
}

