/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Application;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.ResponseList;
import facebook4j.Score;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.ApplicationJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ScoreJSONImpl
extends FacebookResponseImpl
implements Score,
Serializable {
    private static final long serialVersionUID = 4667076189606464769L;
    private IdNameEntity user;
    private Integer score;
    private Application application;
    private String type;

    ScoreJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    ScoreJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.user = new IdNameEntityJSONImpl(json.getJSONObject("user"));
            this.score = z_F4JInternalParseUtil.getPrimitiveInt("score", json);
            this.application = new ApplicationJSONImpl(json.getJSONObject("application"));
            this.type = z_F4JInternalParseUtil.getRawString("type", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public IdNameEntity getUser() {
        return this.user;
    }

    @Override
    public Integer getScore() {
        return this.score;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public String getType() {
        return this.type;
    }

    static ResponseList<Score> createScoreList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Score> scores = new ResponseListImpl<Score>(size, json, new Score[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject scoreJSONObject = list.getJSONObject(i);
                ScoreJSONImpl score = new ScoreJSONImpl(scoreJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(score, scoreJSONObject);
                }
                scores.add(score);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(scores, list);
            }
            return scores;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.application == null ? 0 : this.application.hashCode());
        result = 31 * result + (this.score == null ? 0 : this.score.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScoreJSONImpl other = (ScoreJSONImpl)obj;
        if (this.application == null ? other.application != null : !this.application.equals(other.application)) {
            return false;
        }
        if (this.score == null ? other.score != null : !this.score.equals(other.score)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        return "ScoreJSONImpl [user=" + this.user + ", score=" + this.score + ", application=" + this.application + ", type=" + this.type + "]";
    }
}

