/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.FacebookResponse;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class MetadataJSONImpl
implements FacebookResponse.Metadata,
Serializable {
    private static final long serialVersionUID = 47702530016158838L;
    private FacebookResponse.Metadata.Fields fields;
    private String type;
    private FacebookResponse.Metadata.Connections connections;

    MetadataJSONImpl(JSONObject json) throws FacebookException {
        try {
            this.fields = new FieldsJSONImpl(json.getJSONArray("fields"));
            this.type = z_F4JInternalParseUtil.getRawString("type", json);
            this.connections = new ConnectionsJSONImpl(json.getJSONObject("connections"));
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    public FacebookResponse.Metadata.Fields getFields() {
        return this.fields;
    }

    public String getType() {
        return this.type;
    }

    public FacebookResponse.Metadata.Connections getConnections() {
        return this.connections;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConnectionsJSONImpl
    implements FacebookResponse.Metadata.Connections,
    Serializable {
        private static final long serialVersionUID = -826235388607408320L;
        private Map<String, URL> map = new HashMap<String, URL>();

        ConnectionsJSONImpl(JSONObject json) throws FacebookException {
            try {
                Iterator connectionNames = json.keys();
                while (connectionNames.hasNext()) {
                    String connectionName = (String)connectionNames.next();
                    try {
                        this.map.put(connectionName, new URL((String)json.get(connectionName)));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            catch (JSONException jsone) {
                throw new FacebookException(jsone.getMessage(), jsone);
            }
        }

        @Override
        public URL getURL(String connectionName) {
            return this.map.get(connectionName);
        }

        @Override
        public List<String> getConnectionNames() {
            return Arrays.asList(this.map.keySet().toArray(new String[this.map.size()]));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionsJSONImpl)) {
                return false;
            }
            ConnectionsJSONImpl that = (ConnectionsJSONImpl)o;
            return !(this.map != null ? !this.map.equals(that.map) : that.map != null);
        }

        public int hashCode() {
            return this.map != null ? this.map.hashCode() : 0;
        }

        public String toString() {
            return "ConnectionsJSONImpl{map=" + this.map + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FieldsJSONImpl
    implements FacebookResponse.Metadata.Fields,
    Serializable {
        private static final long serialVersionUID = -4785397260262958674L;
        private List<FacebookResponse.Metadata.Fields.Field> fields = new ArrayList<FacebookResponse.Metadata.Fields.Field>();

        FieldsJSONImpl(JSONArray jsonArray) throws FacebookException {
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject fieldJSONObject = null;
                try {
                    fieldJSONObject = jsonArray.getJSONObject(i);
                }
                catch (JSONException jsone) {
                    throw new FacebookException(jsone.getMessage(), jsone);
                }
                this.fields.add(new FieldJSONImpl(fieldJSONObject));
            }
        }

        @Override
        public List<FacebookResponse.Metadata.Fields.Field> getFields() {
            return this.fields;
        }

        private final class FieldJSONImpl
        implements FacebookResponse.Metadata.Fields.Field,
        Serializable {
            private static final long serialVersionUID = -8533365818279231831L;
            private String name;
            private String description;
            private String type;

            private FieldJSONImpl(JSONObject json) throws FacebookException {
                try {
                    if (!json.isNull("name")) {
                        this.name = json.getString("name");
                    }
                    if (!json.isNull("description")) {
                        this.description = json.getString("description");
                    }
                    if (!json.isNull("type")) {
                        this.type = json.getString("type");
                    }
                }
                catch (JSONException jsone) {
                    throw new FacebookException(jsone.getMessage(), jsone);
                }
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public String getType() {
                return this.type;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof FieldJSONImpl)) {
                    return false;
                }
                FieldJSONImpl fieldJSON = (FieldJSONImpl)o;
                if (this.description != null ? !this.description.equals(fieldJSON.description) : fieldJSON.description != null) {
                    return false;
                }
                if (this.name != null ? !this.name.equals(fieldJSON.name) : fieldJSON.name != null) {
                    return false;
                }
                return !(this.type != null ? !this.type.equals(fieldJSON.type) : fieldJSON.type != null);
            }

            public int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }

            public String toString() {
                return "FieldJSONImpl{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", type='" + this.type + '\'' + '}';
            }
        }
    }
}

