/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Interest;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InterestJSONImpl
extends CategoryJSONImpl
implements Interest,
Serializable {
    private static final long serialVersionUID = -9077908173161437980L;

    InterestJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
    }

    InterestJSONImpl(JSONObject json) throws FacebookException {
        super(json);
    }

    static ResponseList<Interest> createInterestList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Interest> interests = new ResponseListImpl<Interest>(size, json, new Interest[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject interestJSONObject = list.getJSONObject(i);
                InterestJSONImpl interest = new InterestJSONImpl(interestJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(interest, interestJSONObject);
                }
                interests.add(interest);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(interests, list);
            }
            return interests;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String toString() {
        return "InterestJSONImpl [id=" + this.id + ", name=" + this.name + ", category=" + this.category + ", createdTime=" + this.createdTime + "]";
    }
}

