/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.json.DataObjectFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectFactoryUtil {
    private static final Method CLEAR_THREAD_LOCAL_MAP;
    private static final Method REGISTER_JSON_OBJECT;

    private DataObjectFactoryUtil() {
        throw new AssertionError((Object)"not intended to be instantiated.");
    }

    public static void clearThreadLocalMap() {
        try {
            CLEAR_THREAD_LOCAL_MAP.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> T registerJSONObject(T key, Object json) {
        try {
            return (T)REGISTER_JSON_OBJECT.invoke(null, key, json);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        Method[] methods = DataObjectFactory.class.getDeclaredMethods();
        Method clearThreadLocalMap = null;
        Method registerJSONObject = null;
        for (Method method : methods) {
            if (method.getName().equals("clearThreadLocalMap")) {
                clearThreadLocalMap = method;
                clearThreadLocalMap.setAccessible(true);
                continue;
            }
            if (!method.getName().equals("registerJSONObject")) continue;
            registerJSONObject = method;
            registerJSONObject.setAccessible(true);
        }
        if (null == clearThreadLocalMap || null == registerJSONObject) {
            throw new AssertionError();
        }
        CLEAR_THREAD_LOCAL_MAP = clearThreadLocalMap;
        REGISTER_JSON_OBJECT = registerJSONObject;
    }
}

