/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Conversation;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.InboxResponseList;
import facebook4j.Message;
import facebook4j.PagableList;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.InboxResponseListImpl;
import facebook4j.internal.json.MessageJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConversationJSONImpl
extends FacebookResponseImpl
implements Conversation,
Serializable {
    private static final long serialVersionUID = -2666008917993827020L;
    private String id;
    private List<IdNameEntity> senders;
    private String conversation;
    private Date updatedTime;
    private PagableList<Message> messages;
    private Integer unread_count;
    private Integer message_count;

    ConversationJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    ConversationJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("senders")) {
                JSONObject toJSONObject = json.getJSONObject("senders");
                JSONArray toJSONArray = toJSONObject.getJSONArray("data");
                this.senders = new ArrayList<IdNameEntity>();
                for (int i = 0; i < toJSONArray.length(); ++i) {
                    this.senders.add(new IdNameEntityJSONImpl(toJSONArray.getJSONObject(i)));
                }
            } else {
                this.senders = Collections.emptyList();
            }
            this.conversation = z_F4JInternalParseUtil.getRawString("snippet", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            if (!json.isNull("messages")) {
                JSONObject messagesJSONObject = json.getJSONObject("messages");
                if (!messagesJSONObject.isNull("data")) {
                    JSONArray list = messagesJSONObject.getJSONArray("data");
                    int size = list.length();
                    this.messages = new PagableListImpl<Message>(size, messagesJSONObject, new Message[0]);
                    for (int i = 0; i < size; ++i) {
                        MessageJSONImpl message = new MessageJSONImpl(list.getJSONObject(i));
                        this.messages.add(message);
                    }
                } else {
                    this.messages = new PagableListImpl<Message>(1, messagesJSONObject, new Message[0]);
                }
            }
            if (!json.isNull("unread_count")) {
                this.unread_count = z_F4JInternalParseUtil.getPrimitiveInt("unread_count", json);
            }
            if (!json.isNull("message_count")) {
                this.message_count = z_F4JInternalParseUtil.getPrimitiveInt("message_count", json);
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<IdNameEntity> getSenders() {
        return this.senders;
    }

    @Override
    public String getConversation() {
        return this.conversation;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public PagableList<Message> getMessages() {
        return this.messages;
    }

    @Override
    public Integer getUnreadCount() {
        return this.unread_count;
    }

    @Override
    public Integer getMessageCount() {
        return this.message_count;
    }

    static ResponseList<Conversation> createConversationList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Conversation> conversations = new ResponseListImpl<Conversation>(size, json, new Conversation[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject conversationJSONObject = list.getJSONObject(i);
                ConversationJSONImpl conversation = new ConversationJSONImpl(conversationJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(conversation, conversationJSONObject);
                }
                conversations.add(conversation);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(conversations, list);
            }
            return conversations;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    static InboxResponseList<Conversation> createInboxConversationList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            InboxResponseListImpl<Conversation> conversations = new InboxResponseListImpl<Conversation>(size, json, new Conversation[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject conversationJSONObject = list.getJSONObject(i);
                ConversationJSONImpl conversation = new ConversationJSONImpl(conversationJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(conversation, conversationJSONObject);
                }
                conversations.add(conversation);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(conversations, list);
            }
            return conversations;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConversationJSONImpl other = (ConversationJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "MessageJSONImpl{id='" + this.id + '\'' + ", senders=" + this.senders + ", conversation='" + this.conversation + '\'' + ", updatedTime=" + this.updatedTime + ", messages=" + this.messages + ", unread_count=" + this.unread_count + ", message_count=" + this.message_count + '}';
    }
}

