/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;

public final class MilestoneUpdate
implements Serializable {
    private static final long serialVersionUID = 7488064115483210172L;
    private final String title;
    private final String description;
    private final Calendar startTime;

    public MilestoneUpdate(String title, String description, Calendar startTime) {
        this.title = title;
        this.description = description;
        this.startTime = startTime;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("title", this.title));
        params.add(new HttpParameter("description", this.description));
        params.add(new HttpParameter("start_time", z_F4JInternalStringUtil.formatISO8601Datetime(this.startTime)));
        return params.toArray(new HttpParameter[params.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MilestoneUpdate)) {
            return false;
        }
        MilestoneUpdate that = (MilestoneUpdate)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(that.title) : that.title != null);
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MilestoneUpdate{title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", startTime=" + this.startTime + '}';
    }
}

