/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Category;
import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.PagableList;
import facebook4j.ResponseList;
import facebook4j.Tag;
import facebook4j.Video;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.json.TagJSONImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VideoJSONImpl
extends FacebookResponseImpl
implements Video,
Serializable {
    private static final long serialVersionUID = 7462511067275657778L;
    private String id;
    private Category from;
    private List<Tag> tags;
    private String name;
    private String description;
    private URL picture;
    private String embedHtml;
    private List<Video.Format> format;
    private URL icon;
    private URL source;
    private Date createdTime;
    private Date updatedTime;
    private PagableList<Comment> comments;
    private URL link;

    VideoJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    VideoJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            int i;
            int size;
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new CategoryJSONImpl(fromJSONObject);
            }
            if (!json.isNull("tags")) {
                JSONObject tagsJSONObject = json.getJSONObject("tags");
                JSONArray tagsJSONArray = tagsJSONObject.getJSONArray("data");
                size = tagsJSONArray.length();
                this.tags = new ArrayList<Tag>(size);
                for (i = 0; i < size; ++i) {
                    this.tags.add(new TagJSONImpl(tagsJSONArray.getJSONObject(i)));
                }
            } else {
                this.tags = Collections.emptyList();
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.description = z_F4JInternalParseUtil.getRawString("description", json);
            this.picture = z_F4JInternalParseUtil.getURL("picture", json);
            this.embedHtml = z_F4JInternalParseUtil.getRawString("embed_html", json);
            if (!json.isNull("format")) {
                JSONArray formatJSONArray = json.getJSONArray("format");
                int size2 = formatJSONArray.length();
                this.format = new ArrayList<Video.Format>(size2);
                for (int i2 = 0; i2 < size2; ++i2) {
                    this.format.add(new FormatJSONImpl(formatJSONArray.getJSONObject(i2)));
                }
            } else {
                this.format = Collections.emptyList();
            }
            this.icon = z_F4JInternalParseUtil.getURL("icon", json);
            this.source = z_F4JInternalParseUtil.getURL("source", json);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            if (!json.isNull("comments")) {
                JSONObject commentsJSONObject = json.getJSONObject("comments");
                if (!commentsJSONObject.isNull("data")) {
                    JSONArray list = commentsJSONObject.getJSONArray("data");
                    size = list.length();
                    this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                    for (i = 0; i < size; ++i) {
                        CommentJSONImpl comment = new CommentJSONImpl(list.getJSONObject(i));
                        this.comments.add(comment);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, commentsJSONObject, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            this.link = z_F4JInternalParseUtil.getURL("link", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public URL getPicture() {
        return this.picture;
    }

    @Override
    public String getEmbedHtml() {
        return this.embedHtml;
    }

    @Override
    public List<Video.Format> getFormat() {
        return this.format;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public URL getSource() {
        return this.source;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    static ResponseList<Video> createVideoList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Video> videos = new ResponseListImpl<Video>(size, json, new Video[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject videoJSONObject = list.getJSONObject(i);
                VideoJSONImpl video = new VideoJSONImpl(videoJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(video, videoJSONObject);
                }
                videos.add(video);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(videos, list);
            }
            return videos;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VideoJSONImpl other = (VideoJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "VideoJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", tags=" + this.tags + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", picture=" + this.picture + ", embedHtml='" + this.embedHtml + '\'' + ", format=" + this.format + ", icon=" + this.icon + ", source=" + this.source + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", comments=" + this.comments + ", link=" + this.link + '}';
    }

    private final class FormatJSONImpl
    implements Video.Format,
    Serializable {
        private static final long serialVersionUID = 3289798902942149539L;
        private String embedHtml;
        private String filter;
        private Integer height;
        private Integer width;
        private URL picture;

        FormatJSONImpl(JSONObject json) throws FacebookException {
            this.embedHtml = z_F4JInternalParseUtil.getRawString("embed_html", json);
            this.filter = z_F4JInternalParseUtil.getRawString("filter", json);
            this.height = z_F4JInternalParseUtil.getInt("height", json);
            this.width = z_F4JInternalParseUtil.getInt("width", json);
            this.picture = z_F4JInternalParseUtil.getURL("picture", json);
        }

        public String getEmbedHtml() {
            return this.embedHtml;
        }

        public String getFilter() {
            return this.filter;
        }

        public Integer getHeight() {
            return this.height;
        }

        public Integer getWidth() {
            return this.width;
        }

        public URL getPicture() {
            return this.picture;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FormatJSONImpl)) {
                return false;
            }
            FormatJSONImpl that = (FormatJSONImpl)o;
            if (this.embedHtml != null ? !this.embedHtml.equals(that.embedHtml) : that.embedHtml != null) {
                return false;
            }
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
                return false;
            }
            if (this.height != null ? !this.height.equals(that.height) : that.height != null) {
                return false;
            }
            if (this.picture != null ? !this.picture.equals(that.picture) : that.picture != null) {
                return false;
            }
            return !(this.width != null ? !this.width.equals(that.width) : that.width != null);
        }

        public int hashCode() {
            int result = this.embedHtml != null ? this.embedHtml.hashCode() : 0;
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
            result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
            result = 31 * result + (this.picture != null ? this.picture.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "FormatJSONImpl{embedHtml='" + this.embedHtml + '\'' + ", filter='" + this.filter + '\'' + ", height=" + this.height + ", width=" + this.width + ", picture=" + this.picture + '}';
        }
    }
}

