/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Cover;
import facebook4j.FacebookException;
import facebook4j.Page;
import facebook4j.Picture;
import facebook4j.Place;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CoverJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.PictureJSONImpl;
import facebook4j.internal.json.PlaceJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PageJSONImpl
extends FacebookResponseImpl
implements Page,
Serializable {
    private static final long serialVersionUID = -5784064954222183184L;
    private String id;
    private String name;
    private String category;
    private Date createdTime;
    private URL link;
    private Boolean isPublished;
    private Boolean canPost;
    private Integer likes;
    private Place.Location location;
    private String phone;
    private Integer checkins;
    private Picture picture;
    private Cover cover;
    private String website;
    private String companyOverview;
    private Integer talkingAboutCount;
    private String accessToken;
    private Boolean isCommunityPage;
    private Integer wereHereCount;
    private Integer fanCount;
    private String about;
    private String username;
    private String mission;
    private Map<String, String> hours;

    PageJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    PageJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        this.id = z_F4JInternalParseUtil.getRawString("id", json);
        this.name = z_F4JInternalParseUtil.getRawString("name", json);
        this.category = z_F4JInternalParseUtil.getRawString("category", json);
        this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
        try {
            this.link = z_F4JInternalParseUtil.getURL("link", json);
            this.isPublished = z_F4JInternalParseUtil.getBoolean("is_published", json);
            this.canPost = z_F4JInternalParseUtil.getBoolean("can_post", json);
            this.likes = z_F4JInternalParseUtil.getInt("likes", json);
            if (!json.isNull("location")) {
                JSONObject locationJSONObject = json.getJSONObject("location");
                this.location = new PlaceJSONImpl.LocationJSONImpl(locationJSONObject);
            }
            this.phone = z_F4JInternalParseUtil.getRawString("phone", json);
            this.checkins = z_F4JInternalParseUtil.getInt("checkins", json);
            if (!json.isNull("picture")) {
                JSONObject pictureJSONObject = json.getJSONObject("picture");
                this.picture = new PictureJSONImpl(pictureJSONObject);
            }
            if (!json.isNull("cover")) {
                JSONObject coverJSONObject = json.getJSONObject("cover");
                this.cover = new CoverJSONImpl(coverJSONObject);
            }
            this.website = z_F4JInternalParseUtil.getRawString("website", json);
            this.companyOverview = z_F4JInternalParseUtil.getRawString("company_overview", json);
            this.talkingAboutCount = z_F4JInternalParseUtil.getInt("talking_about_count", json);
            this.accessToken = z_F4JInternalParseUtil.getRawString("access_token", json);
            this.isCommunityPage = z_F4JInternalParseUtil.getBoolean("is_community_page", json);
            this.wereHereCount = z_F4JInternalParseUtil.getInt("were_here_count", json);
            this.fanCount = z_F4JInternalParseUtil.getInt("fan_count", json);
            this.about = z_F4JInternalParseUtil.getRawString("about", json);
            this.username = z_F4JInternalParseUtil.getRawString("username", json);
            this.mission = z_F4JInternalParseUtil.getRawString("mission", json);
            this.hours = z_F4JInternalParseUtil.getStringMap("hours", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public Boolean isPublished() {
        return this.isPublished;
    }

    @Override
    public Boolean canPost() {
        return this.canPost;
    }

    @Override
    public Integer getLikes() {
        return this.likes;
    }

    @Override
    public Place.Location getLocation() {
        return this.location;
    }

    @Override
    public String getPhone() {
        return this.phone;
    }

    @Override
    public Integer getCheckins() {
        return this.checkins;
    }

    @Override
    public URL getPicture() {
        return this.picture.getURL();
    }

    public Picture getPagePicture() {
        return this.picture;
    }

    @Override
    public Cover getCover() {
        return this.cover;
    }

    @Override
    public String getWebsite() {
        return this.website;
    }

    @Override
    public String getCompanyOverview() {
        return this.companyOverview;
    }

    @Override
    public Integer getTalkingAboutCount() {
        return this.talkingAboutCount;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Boolean isCommunityPage() {
        return this.isCommunityPage;
    }

    @Override
    public Integer getWereHereCount() {
        return this.wereHereCount;
    }

    @Override
    public Integer getFanCount() {
        return this.fanCount;
    }

    @Override
    public String getAbout() {
        return this.about;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getMission() {
        return this.mission;
    }

    @Override
    public Map<String, String> getHours() {
        return this.hours;
    }

    static ResponseList<Page> createPageList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Page> pages = new ResponseListImpl<Page>(size, json, new Page[0]);
            for (int i = 0; i < size; ++i) {
                PageJSONImpl page = new PageJSONImpl(list.getJSONObject(i));
                pages.add(page);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(pages, json);
            }
            return pages;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageJSONImpl)) {
            return false;
        }
        PageJSONImpl pageJSON = (PageJSONImpl)o;
        return !(this.id != null ? !this.id.equals(pageJSON.id) : pageJSON.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "PageJSONImpl [link=" + this.link + ", isPublished=" + this.isPublished + ", canPost=" + this.canPost + ", likes=" + this.likes + ", location=" + this.location + ", phone=" + this.phone + ", checkins=" + this.checkins + ", picture=" + this.picture + ", cover=" + this.cover + ", website=" + this.website + ", companyOverview=" + this.companyOverview + ", talkingAboutCount=" + this.talkingAboutCount + ", accessToken=" + this.accessToken + ", isCommunityPage=" + this.isCommunityPage + ", wereHereCount=" + this.wereHereCount + ", fanCount=" + this.fanCount + ", id=" + this.id + ", name=" + this.name + ", category=" + this.category + ", createdTime=" + this.createdTime + ", about=" + this.about + ", username=" + this.username + ", mission=" + this.mission + ", hours=" + this.hours + "]";
    }
}

