/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.PagableList;
import facebook4j.Paging;
import facebook4j.Summary;
import facebook4j.internal.json.PagingJSONImpl;
import facebook4j.internal.json.SummaryJSONImpl;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PagableListImpl<T>
extends ArrayList<T>
implements PagableList<T> {
    private static final long serialVersionUID = 3378755563757846762L;
    private Integer count;
    private Paging<T> paging;
    private Summary summary;

    PagableListImpl() {
    }

    PagableListImpl(int size) {
        super(size);
    }

    PagableListImpl(JSONObject json, T ... t) throws FacebookException {
        this.init(json, t);
    }

    PagableListImpl(int size, JSONObject json, T ... t) throws FacebookException {
        super(size);
        this.init(json, t);
    }

    private void init(JSONObject json, T ... t) throws FacebookException {
        Class<?> jsonObjectType = t.getClass().getComponentType();
        if (!json.isNull("count")) {
            this.count = z_F4JInternalParseUtil.getInt("count", json);
        }
        try {
            if (!json.isNull("paging")) {
                JSONObject pagingJSONObject = json.getJSONObject("paging");
                this.paging = new PagingJSONImpl(pagingJSONObject, jsonObjectType);
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
        try {
            if (!json.isNull("summary")) {
                this.summary = new SummaryJSONImpl(json.getJSONObject("summary"));
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public Paging<T> getPaging() {
        return this.paging;
    }

    @Override
    public Summary getSummary() {
        return this.summary;
    }

    @Override
    public String toString() {
        return "PagableListImpl{count=" + this.count + ", paging=" + this.paging + ", summary=" + this.summary + ", " + super.toString() + '}';
    }
}

