/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.auth;

import facebook4j.auth.AuthOption;
import facebook4j.auth.AuthType;
import facebook4j.auth.Display;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.io.Serializable;
import java.util.ArrayList;

public final class DialogAuthOption
implements AuthOption,
Serializable {
    private static final long serialVersionUID = -3742407703218253370L;
    private String state;
    private Display display;
    private AuthType authType;
    private String authNonce;

    public String getQuery(String prefix) {
        ArrayList<String> q = new ArrayList<String>();
        if (this.state != null) {
            q.add("state=" + this.state);
        }
        if (this.display != null) {
            q.add("display=" + this.display.toString().toLowerCase());
        }
        if (this.authType != null) {
            q.add("auth_type=" + this.authType.toString().toLowerCase());
        }
        if (this.authNonce != null) {
            q.add("auth_nonce=" + this.authNonce);
        }
        return prefix + z_F4JInternalStringUtil.join(q.toArray(new String[q.size()]), "&");
    }

    public DialogAuthOption state(String state) {
        this.state = state;
        return this;
    }

    public DialogAuthOption display(Display display) {
        this.display = display;
        return this;
    }

    public DialogAuthOption authType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    public DialogAuthOption authNonce(String authNonce) {
        this.authNonce = authNonce;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DialogAuthOption)) {
            return false;
        }
        DialogAuthOption that = (DialogAuthOption)o;
        if (this.authNonce != null ? !this.authNonce.equals(that.authNonce) : that.authNonce != null) {
            return false;
        }
        if (this.authType != that.authType) {
            return false;
        }
        if (this.display != that.display) {
            return false;
        }
        return !(this.state != null ? !this.state.equals(that.state) : that.state != null);
    }

    public int hashCode() {
        int result = this.state != null ? this.state.hashCode() : 0;
        result = 31 * result + (this.display != null ? this.display.hashCode() : 0);
        result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
        result = 31 * result + (this.authNonce != null ? this.authNonce.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DialogAuthOption{state='" + this.state + '\'' + ", display=" + (Object)((Object)this.display) + ", authType=" + (Object)((Object)this.authType) + ", authNonce='" + this.authNonce + '\'' + '}';
    }
}

