/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.ResponseList;
import facebook4j.Television;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TelevisionJSONImpl
extends CategoryJSONImpl
implements Television,
Serializable {
    private static final long serialVersionUID = 6910720427479022506L;

    TelevisionJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
    }

    TelevisionJSONImpl(JSONObject json) throws FacebookException {
        super(json);
    }

    static ResponseList<Television> createTelevisionList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Television> televisions = new ResponseListImpl<Television>(size, json, new Television[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject televisionJSONObject = list.getJSONObject(i);
                TelevisionJSONImpl television = new TelevisionJSONImpl(televisionJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(television, televisionJSONObject);
                }
                televisions.add(television);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(televisions, list);
            }
            return televisions;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }
}

