/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.PageSetting;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageSettingJSONImpl
extends FacebookResponseImpl
implements PageSetting,
Serializable {
    private static final long serialVersionUID = -6960164932151941721L;
    private String setting;
    private Boolean value;

    PageSettingJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    PageSettingJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) {
        this.setting = z_F4JInternalParseUtil.getRawString("setting", json);
        this.value = z_F4JInternalParseUtil.getBoolean("value", json);
    }

    @Override
    public String getSetting() {
        return this.setting;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    static ResponseList<PageSetting> createLikeList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<PageSetting> settings = new ResponseListImpl<PageSetting>(size, json, new PageSetting[0]);
            for (int i = 0; i < size; ++i) {
                PageSettingJSONImpl setting = new PageSettingJSONImpl(list.getJSONObject(i));
                settings.add(setting);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(settings, json);
            }
            return settings;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageSettingJSONImpl)) {
            return false;
        }
        PageSettingJSONImpl that = (PageSettingJSONImpl)o;
        if (this.setting != null ? !this.setting.equals(that.setting) : that.setting != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.setting != null ? this.setting.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PageSettingJSONImpl{setting='" + this.setting + '\'' + ", value=" + this.value + '}';
    }
}

