/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResponseListImpl<T>
extends PagableListImpl<T>
implements ResponseList<T> {
    private static final long serialVersionUID = 1252744169603170859L;

    ResponseListImpl(JSONObject json, T ... t) throws FacebookException {
        super(json, t);
    }

    ResponseListImpl(int size, JSONObject json, T ... t) throws FacebookException {
        super(size, json, t);
    }

    static ResponseList<JSONObject> createJSONObjectList(HttpResponse res, Configuration conf) throws FacebookException {
        return ResponseListImpl.createJSONObjectList(res.asJSONObject(), conf);
    }

    static ResponseList<JSONObject> createJSONObjectList(JSONObject json) throws FacebookException {
        return ResponseListImpl.createJSONObjectList(json, null);
    }

    private static ResponseList<JSONObject> createJSONObjectList(JSONObject json, Configuration conf) throws FacebookException {
        try {
            if (null != conf && conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONArray jsonArray = json.getJSONArray("data");
            int size = jsonArray.length();
            ResponseListImpl<JSONObject> results = new ResponseListImpl<JSONObject>(size, json, new JSONObject[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (null != conf && conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(jsonObject, jsonObject);
                }
                results.add(jsonObject);
            }
            if (null != conf && conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(results, jsonArray);
            }
            return results;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }
}

