/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Application;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.Notification;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.ApplicationJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NotificationJSONImpl
extends FacebookResponseImpl
implements Notification,
Serializable {
    private static final long serialVersionUID = -4598915714655180624L;
    private String id;
    private IdNameEntity from;
    private IdNameEntity to;
    private Date createdTime;
    private Date updatedTime;
    private String title;
    private URL link;
    private Application application;
    private Boolean unread;
    private Notification.TargetObject targetObject;

    NotificationJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    NotificationJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            if (!json.isNull("to")) {
                JSONObject toJSONObject = json.getJSONObject("to");
                this.to = new IdNameEntityJSONImpl(toJSONObject);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            this.title = z_F4JInternalParseUtil.getRawString("title", json);
            this.link = z_F4JInternalParseUtil.getURL("link", json);
            if (!json.isNull("application")) {
                this.application = new ApplicationJSONImpl(json.getJSONObject("application"));
            }
            if (!json.isNull("unread")) {
                this.unread = z_F4JInternalParseUtil.getFlag("unread", json);
            }
            if (!json.isNull("object")) {
                this.targetObject = new TargetObjectJSONImpl(json.getJSONObject("object"));
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public IdNameEntity getTo() {
        return this.to;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Boolean unread() {
        return this.unread;
    }

    @Override
    public Notification.TargetObject getTargetObject() {
        return this.targetObject;
    }

    static ResponseList<Notification> createNotificationList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Notification> notifications = new ResponseListImpl<Notification>(size, json, new Notification[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject notificationJSONObject = list.getJSONObject(i);
                NotificationJSONImpl notification = new NotificationJSONImpl(notificationJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(notification, notificationJSONObject);
                }
                notifications.add(notification);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(notifications, list);
            }
            return notifications;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotificationJSONImpl other = (NotificationJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "NotificationJSONImpl [id=" + this.id + ", from=" + this.from + ", to=" + this.to + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", title=" + this.title + ", link=" + this.link + ", application=" + this.application + ", unread=" + this.unread + "]";
    }

    private static class TargetObjectJSONImpl
    implements Notification.TargetObject,
    Serializable {
        private static final long serialVersionUID = 6760783049866927374L;
        private String id;
        private String type;

        TargetObjectJSONImpl(JSONObject json) {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            this.type = z_F4JInternalParseUtil.getRawString("type", json);
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TargetObjectJSONImpl)) {
                return false;
            }
            TargetObjectJSONImpl that = (TargetObjectJSONImpl)o;
            return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }

        public String toString() {
            return "TargetObjectJSONImpl{id='" + this.id + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }
}

