/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.auth;

import facebook4j.FacebookException;
import facebook4j.auth.AccessToken;
import facebook4j.auth.Authorization;
import facebook4j.auth.OAuthSupport;
import facebook4j.auth.Security;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpClientWrapper;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.util.z_F4JLRUCache;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OAuthAuthorization
implements Authorization,
OAuthSupport,
Security,
Serializable {
    private static final long serialVersionUID = 2548925849295080874L;
    public static final String HMAC_SHA_256 = "HmacSHA256";
    private final Configuration conf;
    private static transient HttpClientWrapper http;
    private String appId = "";
    private String appSecret;
    private AccessToken oauthToken;
    private String permissions;
    private String callbackURL;
    private boolean appSecretProofEnabled;
    private transient z_F4JLRUCache<String, String> appSecretProofCache;

    public OAuthAuthorization(Configuration conf) {
        this.conf = conf;
        http = new HttpClientWrapper(conf);
        this.setOAuthAppId(conf.getOAuthAppId(), conf.getOAuthAppSecret());
        if (conf.getOAuthPermissions() != null) {
            this.setOAuthPermissions(conf.getOAuthPermissions());
        }
        if (conf.getOAuthAccessToken() != null) {
            this.setOAuthAccessToken(new AccessToken(conf.getOAuthAccessToken(), null));
        }
        this.setAppSecretProofEnabled(conf.isAppSecretProofEnabled());
        this.appSecretProofCache = new z_F4JLRUCache(conf.getAppSecretProofCacheSize());
    }

    private void ensureTokenIsAvailable() {
        if (null == this.oauthToken) {
            throw new IllegalStateException("No Token available.");
        }
    }

    public boolean isEnabled() {
        return null != this.oauthToken;
    }

    public String getOAuthAuthorizationURL(String callbackURL) {
        return this.getOAuthAuthorizationURL(callbackURL, null);
    }

    public String getOAuthAuthorizationURL(String callbackURL, String state) {
        this.callbackURL = callbackURL;
        String url = this.conf.getOAuthAuthorizationURL() + "?client_id=" + this.appId + "&redirect_uri=" + callbackURL;
        if (this.permissions != null) {
            url = url + "&scope=" + this.permissions;
        }
        if (state != null) {
            url = url + "&state=" + state;
        }
        return url;
    }

    public AccessToken getOAuthAccessToken(String oauthCode) throws FacebookException {
        String url = this.getExchangeAccessTokenURL(oauthCode);
        HttpResponse response = http.get(url);
        if (response.getStatusCode() != 200) {
            throw new FacebookException("authorization failed.");
        }
        this.oauthToken = new AccessToken(response);
        return this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(String oauthCode, String callbackURL) throws FacebookException {
        this.callbackURL = callbackURL;
        return this.getOAuthAccessToken(oauthCode);
    }

    protected String getExchangeAccessTokenURL(String oauthCode) {
        return this.conf.getOAuthAccessTokenURL() + "?client_id=" + this.appId + "&client_secret=" + this.appSecret + "&redirect_uri=" + this.callbackURL + "&code=" + oauthCode;
    }

    public AccessToken getOAuthAccessToken() {
        this.ensureTokenIsAvailable();
        return this.oauthToken;
    }

    public AccessToken getOAuthAppAccessToken() throws FacebookException {
        String url = this.getAppAccessTokenURL();
        HttpResponse response = http.get(url);
        if (response.getStatusCode() != 200) {
            throw new FacebookException("authorization failed.");
        }
        this.oauthToken = new AccessToken(response);
        return this.oauthToken;
    }

    private String getAppAccessTokenURL() {
        return this.conf.getOAuthAccessTokenURL() + "?client_id=" + this.appId + "&client_secret=" + this.appSecret + "&grant_type=client_credentials";
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.oauthToken = accessToken;
    }

    public void setOAuthAccessToken(AccessToken accessToken, String callbackURL) {
        this.oauthToken = accessToken;
        this.callbackURL = callbackURL;
    }

    public String getOAuthCallbackURL() {
        return this.callbackURL;
    }

    public void setOAuthCallbackURL(String callbackURL) {
        this.callbackURL = callbackURL;
    }

    public void setOAuthAppId(String appId, String appSecret) {
        this.appId = appId != null ? appId : "";
        this.appSecret = appSecret != null ? appSecret : "";
    }

    public void setOAuthPermissions(String permissions) {
        this.permissions = permissions;
    }

    public void setAppSecretProofEnabled(boolean enabled) {
        this.appSecretProofEnabled = enabled;
    }

    public boolean isAppSecretProofEnabled() {
        return this.appSecretProofEnabled;
    }

    public String generateAppSecretProof() {
        if (this.appSecret == null || !this.isEnabled()) {
            throw new IllegalStateException("App Secret and Access Token are required.");
        }
        String accessToken = this.oauthToken.getToken();
        String cache = this.appSecretProofCache.get(accessToken);
        if (cache != null) {
            return cache;
        }
        byte[] byteHMAC = null;
        try {
            Mac mac = Mac.getInstance(HMAC_SHA_256);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.appSecret.getBytes("UTF-8"), HMAC_SHA_256);
            mac.init(secretKeySpec);
            byteHMAC = mac.doFinal(accessToken.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException ignore) {
        }
        catch (UnsupportedEncodingException ignore) {
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException();
        }
        StringBuilder result = new StringBuilder();
        for (void var8_11 : byteHMAC) {
            result.append(Integer.toString((var8_11 & 0xFF) + 256, 16).substring(1));
        }
        String appSecretProof = result.toString();
        this.appSecretProofCache.put(accessToken, appSecretProof);
        return appSecretProof;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appId == null ? 0 : this.appId.hashCode());
        result = 31 * result + (this.appSecret == null ? 0 : this.appSecret.hashCode());
        result = 31 * result + (this.callbackURL == null ? 0 : this.callbackURL.hashCode());
        result = 31 * result + (this.conf == null ? 0 : this.conf.hashCode());
        result = 31 * result + (this.oauthToken == null ? 0 : this.oauthToken.hashCode());
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthAuthorization other = (OAuthAuthorization)obj;
        if (this.appId == null ? other.appId != null : !this.appId.equals(other.appId)) {
            return false;
        }
        if (this.appSecret == null ? other.appSecret != null : !this.appSecret.equals(other.appSecret)) {
            return false;
        }
        if (this.callbackURL == null ? other.callbackURL != null : !this.callbackURL.equals(other.callbackURL)) {
            return false;
        }
        if (this.oauthToken == null ? other.oauthToken != null : !this.oauthToken.equals(other.oauthToken)) {
            return false;
        }
        return !(this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions));
    }

    public String toString() {
        return "OAuthAuthorization [appId=" + this.appId + ", appSecret=****************" + ", oauthToken=" + this.oauthToken + ", permissions=" + this.permissions + ", callbackURL=" + this.callbackURL + "]";
    }
}

