/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.Media;
import facebook4j.internal.http.HttpParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

public class VideoUpdate
implements Serializable {
    private static final long serialVersionUID = -757292229143435735L;
    private Media source;
    private String title;
    private String description;
    private Boolean published;
    private Integer scheduledPublishTime;

    public VideoUpdate(Media source) {
        this.source = source;
    }

    public Media getSource() {
        return this.source;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public VideoUpdate title(String title) {
        this.setTitle(title);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public VideoUpdate description(String description) {
        this.setDescription(description);
        return this;
    }

    public Boolean getPublished() {
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public VideoUpdate published(boolean published) {
        this.setPublished(published);
        return this;
    }

    public Integer getScheduledPublishTime() {
        return this.scheduledPublishTime;
    }

    public void setScheduledPublishTime(Integer scheduledPublishTime) {
        this.scheduledPublishTime = scheduledPublishTime;
    }

    public void setScheduledPublishTime(Date scheduledPublishTime) {
        long time = scheduledPublishTime.getTime() / 1000L;
        this.setScheduledPublishTime(Long.valueOf(time).intValue());
    }

    public VideoUpdate scheduledPublishTime(Integer scheduledPublishTime) {
        this.setScheduledPublishTime(scheduledPublishTime);
        return this;
    }

    public VideoUpdate scheduledPublishTime(Date scheduledPublishTime) {
        long time = scheduledPublishTime.getTime() / 1000L;
        return this.scheduledPublishTime(Long.valueOf(time).intValue());
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("source", this.source.getMediaFile()));
        if (this.title != null) {
            params.add(new HttpParameter("title", this.title));
        }
        if (this.description != null) {
            params.add(new HttpParameter("description", this.description));
        }
        if (this.published != null) {
            params.add(new HttpParameter("published", this.published));
        }
        if (this.scheduledPublishTime != null) {
            params.add(new HttpParameter("scheduled_publish_time", this.scheduledPublishTime));
        }
        return params.toArray(new HttpParameter[params.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VideoUpdate)) {
            return false;
        }
        VideoUpdate that = (VideoUpdate)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.published != null ? !this.published.equals(that.published) : that.published != null) {
            return false;
        }
        if (this.scheduledPublishTime != null ? !this.scheduledPublishTime.equals(that.scheduledPublishTime) : that.scheduledPublishTime != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(that.title) : that.title != null);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.published != null ? this.published.hashCode() : 0);
        result = 31 * result + (this.scheduledPublishTime != null ? this.scheduledPublishTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "VideoUpdate{source=" + this.source + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", published=" + this.published + ", scheduledPublishTime=" + this.scheduledPublishTime + '}';
    }
}

