/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.Media;
import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class OfferUpdate
implements Serializable {
    private static final long serialVersionUID = -6990777853567019761L;
    private String title;
    private Calendar expirationTime;
    private String terms;
    private URL imageURL;
    private Media image;
    private Integer claimLimit;
    private String couponType;
    private String qrcode;
    private String barcode;
    private URL redemptionLink;
    private String redemptionCode;
    private Boolean isPublished;
    private Integer scheduledPublishTime;
    private Calendar reminderTime;

    public OfferUpdate() {
    }

    public OfferUpdate(String title, Calendar expirationTime, URL imageURL) {
        this.title = title;
        this.expirationTime = expirationTime;
        this.imageURL = imageURL;
    }

    public OfferUpdate(String title, Calendar expirationTime, Media image) {
        this.title = title;
        this.expirationTime = expirationTime;
        this.image = image;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public OfferUpdate title(String title) {
        this.setTitle(title);
        return this;
    }

    public Calendar getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Calendar expirationTime) {
        this.expirationTime = expirationTime;
    }

    public OfferUpdate expirationTime(Calendar expirationTime) {
        this.setExpirationTime(expirationTime);
        return this;
    }

    public String getTerms() {
        return this.terms;
    }

    public void setTerms(String terms) {
        this.terms = terms;
    }

    public OfferUpdate terms(String terms) {
        this.setTerms(terms);
        return this;
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(URL imageURL) {
        this.imageURL = imageURL;
    }

    public OfferUpdate imageURL(URL imageURL) {
        this.setImageURL(imageURL);
        return this;
    }

    public Media getImage() {
        return this.image;
    }

    public void setImage(Media image) {
        this.image = image;
    }

    public OfferUpdate image(Media image) {
        this.setImage(image);
        return this;
    }

    public Integer getClaimLimit() {
        return this.claimLimit;
    }

    public void setClaimLimit(Integer claimLimit) {
        this.claimLimit = claimLimit;
    }

    public OfferUpdate claimLimit(Integer claimLimit) {
        this.setClaimLimit(claimLimit);
        return this;
    }

    public String getCouponType() {
        return this.couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public OfferUpdate couponType(String couponType) {
        this.setCouponType(couponType);
        return this;
    }

    public String getQrcode() {
        return this.qrcode;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    public OfferUpdate qrcode(String qrcode) {
        this.setQrcode(qrcode);
        return this;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public OfferUpdate barcode(String barcode) {
        this.setBarcode(barcode);
        return this;
    }

    public URL getRedemptionLink() {
        return this.redemptionLink;
    }

    public void setRedemptionLink(URL redemptionLink) {
        this.redemptionLink = redemptionLink;
    }

    public OfferUpdate redemptionLink(URL redemptionLink) {
        this.setRedemptionLink(redemptionLink);
        return this;
    }

    public String getRedemptionCode() {
        return this.redemptionCode;
    }

    public void setRedemptionCode(String redemptionCode) {
        this.redemptionCode = redemptionCode;
    }

    public OfferUpdate redemptionCode(String redemptionCode) {
        this.setRedemptionCode(redemptionCode);
        return this;
    }

    public Boolean getPublished() {
        return this.isPublished;
    }

    public void setPublished(Boolean published) {
        this.isPublished = published;
    }

    public OfferUpdate isPublished(Boolean published) {
        this.setPublished(published);
        return this;
    }

    public Integer getScheduledPublishTime() {
        return this.scheduledPublishTime;
    }

    public void setScheduledPublishTime(Integer scheduledPublishTime) {
        this.scheduledPublishTime = scheduledPublishTime;
    }

    public OfferUpdate scheduledPublishTime(Integer scheduledPublishTime) {
        this.setScheduledPublishTime(scheduledPublishTime);
        return this;
    }

    public OfferUpdate scheduledPublishTime(Date scheduledPublishTime) {
        long time = scheduledPublishTime.getTime() / 1000L;
        return this.scheduledPublishTime(Long.valueOf(time).intValue());
    }

    public Calendar getReminderTime() {
        return this.reminderTime;
    }

    public void setReminderTime(Calendar reminderTime) {
        this.reminderTime = reminderTime;
    }

    public OfferUpdate reminderTime(Calendar reminderTime) {
        this.setReminderTime(reminderTime);
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("title", this.title));
        params.add(new HttpParameter("expiration_time", z_F4JInternalStringUtil.formatISO8601Datetime(this.expirationTime)));
        if (this.terms != null) {
            params.add(new HttpParameter("terms", this.terms));
        }
        if (this.imageURL != null) {
            params.add(new HttpParameter("image_url", this.imageURL.toString()));
        }
        if (this.image != null) {
            params.add(new HttpParameter("image", this.image.getMediaFile()));
        }
        if (this.claimLimit != null) {
            params.add(new HttpParameter("claim_limit", this.claimLimit));
        }
        if (this.couponType != null) {
            params.add(new HttpParameter("coupon_type", this.couponType));
        }
        if (this.qrcode != null) {
            params.add(new HttpParameter("qrcode", this.qrcode));
        }
        if (this.barcode != null) {
            params.add(new HttpParameter("barcode", this.barcode));
        }
        if (this.redemptionLink != null) {
            params.add(new HttpParameter("redemption_link", this.redemptionLink.toString()));
        }
        if (this.redemptionCode != null) {
            params.add(new HttpParameter("redemption_code", this.redemptionCode));
        }
        if (this.isPublished != null) {
            params.add(new HttpParameter("published", this.isPublished));
        }
        if (this.scheduledPublishTime != null) {
            params.add(new HttpParameter("scheduled_publish_time", this.scheduledPublishTime));
        }
        if (this.reminderTime != null) {
            params.add(new HttpParameter("reminder_time", z_F4JInternalStringUtil.formatISO8601Datetime(this.reminderTime)));
        }
        return params.toArray(new HttpParameter[params.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OfferUpdate)) {
            return false;
        }
        OfferUpdate that = (OfferUpdate)o;
        if (this.barcode != null ? !this.barcode.equals(that.barcode) : that.barcode != null) {
            return false;
        }
        if (this.claimLimit != null ? !this.claimLimit.equals(that.claimLimit) : that.claimLimit != null) {
            return false;
        }
        if (this.couponType != null ? !this.couponType.equals(that.couponType) : that.couponType != null) {
            return false;
        }
        if (this.expirationTime != null ? !this.expirationTime.equals(that.expirationTime) : that.expirationTime != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imageURL != null ? !this.imageURL.equals(that.imageURL) : that.imageURL != null) {
            return false;
        }
        if (this.isPublished != null ? !this.isPublished.equals(that.isPublished) : that.isPublished != null) {
            return false;
        }
        if (this.qrcode != null ? !this.qrcode.equals(that.qrcode) : that.qrcode != null) {
            return false;
        }
        if (this.redemptionCode != null ? !this.redemptionCode.equals(that.redemptionCode) : that.redemptionCode != null) {
            return false;
        }
        if (this.redemptionLink != null ? !this.redemptionLink.equals(that.redemptionLink) : that.redemptionLink != null) {
            return false;
        }
        if (this.reminderTime != null ? !this.reminderTime.equals(that.reminderTime) : that.reminderTime != null) {
            return false;
        }
        if (this.scheduledPublishTime != null ? !this.scheduledPublishTime.equals(that.scheduledPublishTime) : that.scheduledPublishTime != null) {
            return false;
        }
        if (this.terms != null ? !this.terms.equals(that.terms) : that.terms != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(that.title) : that.title != null);
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.expirationTime != null ? this.expirationTime.hashCode() : 0);
        result = 31 * result + (this.terms != null ? this.terms.hashCode() : 0);
        result = 31 * result + (this.imageURL != null ? this.imageURL.hashCode() : 0);
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.claimLimit != null ? this.claimLimit.hashCode() : 0);
        result = 31 * result + (this.couponType != null ? this.couponType.hashCode() : 0);
        result = 31 * result + (this.qrcode != null ? this.qrcode.hashCode() : 0);
        result = 31 * result + (this.barcode != null ? this.barcode.hashCode() : 0);
        result = 31 * result + (this.redemptionLink != null ? this.redemptionLink.hashCode() : 0);
        result = 31 * result + (this.redemptionCode != null ? this.redemptionCode.hashCode() : 0);
        result = 31 * result + (this.isPublished != null ? this.isPublished.hashCode() : 0);
        result = 31 * result + (this.scheduledPublishTime != null ? this.scheduledPublishTime.hashCode() : 0);
        result = 31 * result + (this.reminderTime != null ? this.reminderTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OfferUpdate{title='" + this.title + '\'' + ", expirationTime=" + this.expirationTime + ", terms='" + this.terms + '\'' + ", imageURL=" + this.imageURL + ", image=" + this.image + ", claimLimit=" + this.claimLimit + ", couponType='" + this.couponType + '\'' + ", qrcode='" + this.qrcode + '\'' + ", barcode='" + this.barcode + '\'' + ", redemptionLink=" + this.redemptionLink + ", redemptionCode='" + this.redemptionCode + '\'' + ", isPublished=" + this.isPublished + ", scheduledPublishTime=" + this.scheduledPublishTime + ", reminderTime=" + this.reminderTime + '}';
    }
}

