/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime.receiver;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.fabric3.api.binding.file.InvalidDataException;
import org.fabric3.api.binding.file.ServiceAdapter;
import org.fabric3.api.binding.file.annotation.Strategy;
import org.fabric3.api.host.util.IOHelper;
import org.fabric3.binding.file.runtime.receiver.FileEntry;
import org.fabric3.binding.file.runtime.receiver.ReceiverConfiguration;
import org.fabric3.binding.file.runtime.receiver.ReceiverMonitor;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageCache;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.container.wire.Interceptor;

public class FileSystemReceiver
implements Runnable {
    private File location;
    private File lockDirectory;
    private File errorDirectory;
    private File archiveDirectory;
    private Strategy strategy;
    private Pattern filePattern;
    private long delay;
    private Interceptor interceptor;
    private ScheduledExecutorService executorService;
    private ServiceAdapter adapter;
    private ReceiverMonitor monitor;
    private Map<String, FileEntry> cache = new ConcurrentHashMap<String, FileEntry>();
    private ScheduledFuture<?> future;

    public FileSystemReceiver(ReceiverConfiguration configuration) {
        this.location = configuration.getLocation();
        this.strategy = configuration.getStrategy();
        this.errorDirectory = configuration.getErrorLocation();
        this.archiveDirectory = configuration.getArchiveLocation();
        this.filePattern = configuration.getFilePattern();
        this.interceptor = configuration.getInterceptor();
        this.monitor = configuration.getMonitor();
        this.lockDirectory = configuration.getLockDirectory();
        this.adapter = configuration.getAdapter();
        this.delay = configuration.getDelay();
    }

    public void start() {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.future = this.executorService.scheduleWithFixedDelay(this, this.delay, this.delay, TimeUnit.MILLISECONDS);
        this.createDirectories();
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    @Override
    public synchronized void run() {
        File[] pathFiles;
        ArrayList<File> files = new ArrayList<File>();
        if (!this.location.isDirectory()) {
            return;
        }
        for (File file : pathFiles = this.location.listFiles()) {
            if (this.ignore(file)) continue;
            files.add(file);
        }
        if (files.isEmpty()) {
            return;
        }
        try {
            this.processFiles(files);
        }
        catch (RuntimeException e) {
            this.monitor.error(e);
        }
        catch (Error e) {
            this.monitor.error(e);
            throw e;
        }
    }

    void createDirectories() {
        this.lockDirectory.mkdirs();
        this.errorDirectory.mkdirs();
        if (this.archiveDirectory != null) {
            this.archiveDirectory.mkdirs();
        }
    }

    private synchronized void processFiles(List<File> files) {
        for (File file : files) {
            String name = file.getName();
            FileEntry cached = this.cache.get(name);
            if (cached == null) {
                cached = new FileEntry(file);
                this.cache.put(name, cached);
                continue;
            }
            if (cached.isChanged()) continue;
            this.processFile(file);
        }
    }

    private boolean ignore(File file) {
        String name = file.getName();
        return name.startsWith(".") || file.isDirectory() || !this.filePattern.matcher(name).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File file) {
        FileLock fileLock;
        FileChannel lockChannel;
        String name = file.getName();
        this.cache.remove(name);
        File lockFile = new File(this.lockDirectory, file.getName() + ".f3");
        try {
            lockChannel = new RandomAccessFile(lockFile, "rw").getChannel();
            fileLock = lockChannel.tryLock();
            if (fileLock == null) {
                return;
            }
        }
        catch (OverlappingFileLockException e) {
            return;
        }
        catch (IOException e) {
            this.monitor.error(e);
            return;
        }
        try {
            Object[] payload;
            try {
                payload = this.adapter.beforeInvoke(file);
            }
            catch (InvalidDataException e) {
                this.monitor.error(e);
                this.handleError(file, (Exception)((Object)e));
                this.releaseLock(lockFile, fileLock, lockChannel);
                return;
            }
            WorkContext workContext = WorkContextCache.getAndResetThreadWorkContext();
            Message message = MessageCache.getAndResetMessage();
            try {
                message.setWorkContext(workContext);
                Message response = this.dispatch(payload, message);
                this.afterInvoke(file, payload);
                if (response.isFault()) {
                    Exception error = (Exception)response.getBody();
                    this.handleError(file, error);
                    this.monitor.error("Error processing file: " + file.getName(), error);
                } else if (Strategy.ARCHIVE == this.strategy) {
                    this.archiveFile(file);
                } else {
                    this.deleteFile(file);
                }
            }
            catch (RuntimeException e) {
                this.afterInvoke(file, payload);
                throw e;
            }
            finally {
                message.reset();
                workContext.reset();
            }
        }
        finally {
            this.releaseLock(lockFile, fileLock, lockChannel);
        }
    }

    private Message dispatch(Object[] payload, Message message) {
        message.setBody((Object)payload);
        return this.interceptor.invoke(message);
    }

    private void afterInvoke(File file, Object[] payload) {
        try {
            this.adapter.afterInvoke(file, payload);
        }
        catch (IOException e) {
            this.monitor.error(e);
        }
    }

    private void archiveFile(File file) {
        try {
            this.adapter.archive(file, this.archiveDirectory);
        }
        catch (IOException e) {
            this.monitor.error(e);
        }
    }

    private void deleteFile(File file) {
        try {
            this.adapter.delete(file);
        }
        catch (IOException e) {
            this.monitor.error(e);
        }
    }

    private void handleError(File file, Exception e) {
        try {
            this.adapter.error(file, this.errorDirectory, e);
        }
        catch (IOException ex) {
            this.monitor.error(ex);
        }
    }

    private void releaseLock(File lockFile, FileLock lock, FileChannel lockChannel) {
        if (lock != null) {
            try {
                lock.release();
                IOHelper.closeQuietly((Closeable)lockChannel);
                if (lockFile.exists()) {
                    lockFile.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

