/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime;

import java.io.File;
import java.net.URI;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.file.ReferenceAdapter;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.binding.file.provision.FileBindingWireTarget;
import org.fabric3.binding.file.runtime.DefaultReferenceAdapter;
import org.fabric3.binding.file.runtime.ReferenceAdaptorWrapper;
import org.fabric3.binding.file.runtime.sender.FileSystemInterceptor;
import org.fabric3.spi.container.builder.TargetWireAttacher;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSource;
import org.fabric3.spi.util.ClassLoading;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Key(value="org.fabric3.binding.file.provision.FileBindingWireTarget")
public class FileTargetWireAttacher
implements TargetWireAttacher<FileBindingWireTarget> {
    private static final ReferenceAdapter ADAPTER = new DefaultReferenceAdapter();
    private File baseDir;
    private ComponentManager manager;

    public FileTargetWireAttacher(@Reference ComponentManager manager, @Reference HostInfo hostInfo) {
        this.manager = manager;
        this.baseDir = new File(hostInfo.getDataDir(), "outbox");
    }

    public void attach(PhysicalWireSource source, FileBindingWireTarget target, Wire wire) throws Fabric3Exception {
        File location = this.resolve(target.getLocation());
        location.mkdirs();
        ReferenceAdapter adapter = this.getAdaptor(target);
        FileSystemInterceptor interceptor = new FileSystemInterceptor(location, adapter);
        for (InvocationChain chain : wire.getInvocationChains()) {
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    private File resolve(String location) {
        File file = new File(location);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.baseDir, location);
    }

    private ReferenceAdapter getAdaptor(FileBindingWireTarget source) throws Fabric3Exception {
        String adapterClass = source.getAdapterClass();
        if (adapterClass == null) {
            URI adapterUri = source.getAdapterUri();
            if (adapterUri == null) {
                return ADAPTER;
            }
            Component component = this.manager.getComponent(adapterUri);
            if (component == null) {
                throw new Fabric3Exception("Binding adaptor component not found: " + adapterUri);
            }
            if (!(component instanceof AtomicComponent)) {
                throw new Fabric3Exception("Adaptor component must implement " + AtomicComponent.class.getName() + ": " + adapterUri);
            }
            return new ReferenceAdaptorWrapper((AtomicComponent)component);
        }
        ClassLoader loader = source.getClassLoader();
        return (ReferenceAdapter)ClassLoading.instantiate(ReferenceAdapter.class, (ClassLoader)loader, (String)adapterClass);
    }
}

