/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime;

import java.io.File;
import java.net.URI;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.file.ServiceAdapter;
import org.fabric3.api.binding.file.annotation.Strategy;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.binding.file.provision.FileBindingWireSource;
import org.fabric3.binding.file.runtime.DataHandlerServiceAdapter;
import org.fabric3.binding.file.runtime.DefaultServiceAdapter;
import org.fabric3.binding.file.runtime.ServiceAdaptorWrapper;
import org.fabric3.binding.file.runtime.receiver.PassThroughInterceptor;
import org.fabric3.binding.file.runtime.receiver.ReceiverConfiguration;
import org.fabric3.binding.file.runtime.receiver.ReceiverManager;
import org.fabric3.binding.file.runtime.receiver.ReceiverMonitor;
import org.fabric3.spi.container.builder.SourceWireAttacher;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.fabric3.spi.util.ClassLoading;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Key(value="org.fabric3.binding.file.provision.FileBindingWireSource")
public class FileSourceWireAttacher
implements SourceWireAttacher<FileBindingWireSource> {
    private static final ServiceAdapter ADAPTER = new DefaultServiceAdapter();
    private static final ServiceAdapter JAF_ADAPTER = new DataHandlerServiceAdapter();
    private ReceiverManager receiverManager;
    private ComponentManager manager;
    private ReceiverMonitor monitor;
    private File baseDir;

    public FileSourceWireAttacher(@Reference ReceiverManager receiverManager, @Reference ComponentManager manager, @Reference HostInfo hostInfo, @Monitor ReceiverMonitor monitor) {
        this.receiverManager = receiverManager;
        this.manager = manager;
        this.monitor = monitor;
        this.baseDir = new File(hostInfo.getDataDir(), "inbox");
    }

    public void attach(FileBindingWireSource source, PhysicalWireTarget target, Wire wire) {
        String id = source.getUri().toString();
        File location = this.getLocation(source);
        File errorLocation = this.getErrorLocation(source);
        File archiveLocation = this.getArchiveLocation(source);
        String pattern = source.getPattern();
        Strategy strategy = source.getStrategy();
        PassThroughInterceptor interceptor = new PassThroughInterceptor();
        for (InvocationChain chain : wire.getInvocationChains()) {
            chain.addInterceptor((Interceptor)interceptor);
        }
        ServiceAdapter adapter = this.getAdaptor(source);
        long delay = source.getDelay();
        ReceiverConfiguration configuration = new ReceiverConfiguration(id, location, pattern, strategy, errorLocation, archiveLocation, interceptor, adapter, delay, this.monitor);
        this.receiverManager.create(configuration);
    }

    public void detach(FileBindingWireSource source, PhysicalWireTarget target) {
        String id = source.getUri().toString();
        this.receiverManager.remove(id);
    }

    private File getLocation(FileBindingWireSource source) {
        String location = source.getLocation();
        return this.resolve(location);
    }

    private File getArchiveLocation(FileBindingWireSource source) {
        File archiveLocation = null;
        String archiveLocationStr = source.getArchiveLocation();
        if (archiveLocationStr != null) {
            archiveLocation = this.resolve(archiveLocationStr);
        }
        return archiveLocation;
    }

    private File getErrorLocation(FileBindingWireSource source) {
        File errorLocation = null;
        String errorLocationStr = source.getErrorLocation();
        if (errorLocationStr != null) {
            errorLocation = this.resolve(errorLocationStr);
        }
        return errorLocation;
    }

    private File resolve(String location) {
        File file = new File(location);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.baseDir, location);
    }

    private ServiceAdapter getAdaptor(FileBindingWireSource source) throws Fabric3Exception {
        String adapterClass = source.getAdapterClass();
        if (adapterClass == null) {
            URI adapterUri = source.getAdapterUri();
            if (adapterUri == null) {
                return source.isDataHandler() ? JAF_ADAPTER : ADAPTER;
            }
            Component component = this.manager.getComponent(adapterUri);
            if (component == null) {
                throw new Fabric3Exception("Binding adaptor component not found: " + adapterUri);
            }
            if (!(component instanceof AtomicComponent)) {
                throw new Fabric3Exception("Adaptor component must implement " + AtomicComponent.class.getName() + ": " + adapterUri);
            }
            return new ServiceAdaptorWrapper((AtomicComponent)component);
        }
        ClassLoader loader = source.getClassLoader();
        return (ServiceAdapter)ClassLoading.instantiate(ServiceAdapter.class, (ClassLoader)loader, (String)adapterClass);
    }
}

