/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.introspection;

import java.lang.annotation.Annotation;
import org.fabric3.api.binding.file.annotation.Strategy;
import org.fabric3.api.binding.file.model.FileBinding;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.Service;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.AbstractBindingPostProcessor;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class FileBindingPostProcessor
extends AbstractBindingPostProcessor<org.fabric3.api.binding.file.annotation.FileBinding> {
    public FileBindingPostProcessor() {
        super(org.fabric3.api.binding.file.annotation.FileBinding.class);
    }

    protected Binding processReference(org.fabric3.api.binding.file.annotation.FileBinding annotation, Reference reference, Class<?> implClass, IntrospectionContext context) {
        return this.createBinding(annotation, implClass, context);
    }

    protected Binding processService(org.fabric3.api.binding.file.annotation.FileBinding annotation, Service<ComponentType> service, InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        return this.createBinding(annotation, implClass, context);
    }

    protected Binding processServiceCallback(org.fabric3.api.binding.file.annotation.FileBinding annotation, Service<ComponentType> service, InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        return null;
    }

    protected Binding processReferenceCallback(org.fabric3.api.binding.file.annotation.FileBinding annotation, Reference reference, Class<?> implClass, IntrospectionContext context) {
        return null;
    }

    private FileBinding createBinding(org.fabric3.api.binding.file.annotation.FileBinding annotation, Class<?> implClass, IntrospectionContext context) {
        String location;
        if (!this.isActiveForEnvironment(annotation.environments())) {
            return null;
        }
        String name = annotation.name();
        if (name.isEmpty()) {
            name = "FileBinding";
        }
        if ((location = annotation.location()).isEmpty()) {
            InvalidAnnotation error = new InvalidAnnotation("File binding annotation must specify a location", implClass, (Annotation)annotation, implClass);
            context.addError((ValidationFailure)error);
        }
        Strategy strategy = annotation.strategy();
        String archiveLocation = this.getNullableValue(annotation.archiveLocation());
        if (strategy == Strategy.ARCHIVE && archiveLocation == null) {
            InvalidAnnotation error = new InvalidAnnotation("File binding annotation must specify an archive location", implClass, (Annotation)annotation, implClass);
            context.addError((ValidationFailure)error);
        }
        String errorLocation = this.getNullableValue(annotation.errorLocation());
        String adapterUri = this.getNullableValue(annotation.adaptor());
        String pattern = this.getNullableValue(annotation.pattern());
        long delay = annotation.delay();
        if (delay < -1L) {
            InvalidAnnotation error = new InvalidAnnotation("Invalid delay value specified on file binding", implClass, (Annotation)annotation, implClass);
            context.addError((ValidationFailure)error);
        }
        return new FileBinding(name, pattern, location, strategy, archiveLocation, errorLocation, null, adapterUri, delay);
    }
}

