/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.introspection;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.file.annotation.Strategy;
import org.fabric3.api.binding.file.model.FileBinding;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
@Key(value="{urn:fabric3.org}binding.file")
public class FileBindingLoader
extends AbstractValidatingTypeLoader<FileBinding> {
    public FileBindingLoader() {
        this.addAttributes(new String[]{"requires", "location", "archive.location", "error.location", "strategy", "pattern", "name", "adapter", "adapter.component", "policySets", "delay"});
    }

    public FileBinding load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String bindingName = reader.getAttributeValue(null, "name");
        String location = reader.getAttributeValue(null, "location");
        if (location == null) {
            MissingAttribute error = new MissingAttribute("The location attribute must be specified", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)error);
        }
        String archiveLocation = reader.getAttributeValue(null, "archive.location");
        Strategy strategy = this.parseStrategy(reader);
        if (Strategy.ARCHIVE == strategy && archiveLocation == null) {
            MissingAttribute error = new MissingAttribute("An archive location must be specified", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)error);
        }
        String errorLocation = reader.getAttributeValue(null, "error.location");
        String adapterClass = reader.getAttributeValue(null, "adapter");
        String adapterUri = reader.getAttributeValue(null, "adapter.component");
        String pattern = reader.getAttributeValue(null, "pattern");
        long delay = this.parseDelay(reader, context);
        FileBinding binding = new FileBinding(bindingName, pattern, location, strategy, archiveLocation, errorLocation, adapterClass, adapterUri, delay);
        this.validateAttributes(reader, context, new ModelObject[]{binding});
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        return binding;
    }

    private Strategy parseStrategy(XMLStreamReader reader) {
        String strategyAttr = reader.getAttributeValue(null, "strategy");
        if (strategyAttr == null || Strategy.DELETE.toString().toUpperCase().equals(strategyAttr)) {
            return Strategy.DELETE;
        }
        return Strategy.valueOf((String)strategyAttr.toUpperCase());
    }

    private long parseDelay(XMLStreamReader reader, IntrospectionContext context) {
        long delay = -1L;
        String delayStr = reader.getAttributeValue(null, "delay");
        if (delayStr != null) {
            try {
                delay = Long.parseLong(delayStr);
            }
            catch (NumberFormatException e) {
                Location location = reader.getLocation();
                InvalidValue error = new InvalidValue("Invalid delay value", location, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        return delay;
    }
}

