/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.generator;

import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.activation.DataHandler;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.file.annotation.Strategy;
import org.fabric3.api.binding.file.model.FileBinding;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.binding.file.provision.FileBindingWireSource;
import org.fabric3.binding.file.provision.FileBindingWireTarget;
import org.fabric3.spi.domain.generator.WireBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.type.java.JavaType;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Key(value="org.fabric3.api.binding.file.model.FileBinding")
public class FileWireBindingGenerator
implements WireBindingGenerator<FileBinding> {
    private static final String REGEX_ALL = ".*";
    private HostInfo info;
    private long defaultDelay = 2000L;

    @Property(required=false)
    public void setDelay(long delay) {
        this.defaultDelay = delay;
    }

    public FileWireBindingGenerator(@Reference HostInfo info) {
        this.info = info;
    }

    public FileBindingWireSource generateSource(LogicalBinding<FileBinding> binding, ServiceContract contract, List<LogicalOperation> operations) {
        this.validateServiceContract(contract);
        boolean dataHandler = this.isDataHandler(contract);
        FileBinding definition = (FileBinding)binding.getDefinition();
        String pattern = definition.getPattern();
        if (pattern == null) {
            pattern = REGEX_ALL;
        }
        String location = definition.getLocation();
        Strategy strategy = definition.getStrategy();
        String archiveLocation = definition.getArchiveLocation();
        URI uri = ((LogicalBindable)binding.getParent()).getUri();
        String errorLocation = definition.getErrorLocation();
        if (errorLocation == null) {
            throw new Fabric3Exception("Error location must be specified on the file binding configuration for " + uri);
        }
        String adapterClass = definition.getAdapterClass();
        URI adaptorUri = this.getAdaptorUri(definition);
        long delay = definition.getDelay();
        if (delay == -1L) {
            delay = this.defaultDelay;
        }
        return new FileBindingWireSource(uri, pattern, location, strategy, archiveLocation, errorLocation, adapterClass, adaptorUri, delay, dataHandler);
    }

    public FileBindingWireTarget generateTarget(LogicalBinding<FileBinding> binding, ServiceContract contract, List<LogicalOperation> operations) {
        this.validateReferenceContract(contract);
        FileBinding definition = (FileBinding)binding.getDefinition();
        String location = definition.getLocation();
        String adapterClass = definition.getAdapterClass();
        URI adaptorUri = this.getAdaptorUri(definition);
        return new FileBindingWireTarget(location, adapterClass, adaptorUri);
    }

    private void validateReferenceContract(ServiceContract contract) throws Fabric3Exception {
        if (contract.getOperations().size() != 1) {
            throw new Fabric3Exception("File transfer binding contracts must contain one operation of the form openStream(String id)");
        }
        Operation operation = (Operation)contract.getOperations().get(0);
        DataType dataType = (DataType)operation.getInputTypes().get(0);
        if (!(dataType instanceof JavaType)) {
            throw new Fabric3Exception("Unsupported parameter type on binding contract: " + dataType);
        }
        JavaType javaType = (JavaType)dataType;
        if (!String.class.isAssignableFrom(javaType.getType())) {
            throw new Fabric3Exception("Parameter type on binding contract must be a string: " + dataType);
        }
        DataType outputType = operation.getOutputType();
        if (!(outputType instanceof JavaType)) {
            throw new Fabric3Exception("Unsupported output type on binding contract: " + outputType);
        }
        JavaType javaOutputType = (JavaType)outputType;
        if (!OutputStream.class.isAssignableFrom(javaOutputType.getType())) {
            throw new Fabric3Exception("Output type on binding contract must be a java.io.OutputStream: " + dataType);
        }
    }

    private void validateServiceContract(ServiceContract contract) throws Fabric3Exception {
        if (contract.getOperations().size() > 1 || contract.getOperations().isEmpty()) {
            throw new Fabric3Exception("File transfer binding contracts must contain one operation");
        }
    }

    private boolean isDataHandler(ServiceContract contract) {
        for (Operation operation : contract.getOperations()) {
            for (DataType dataType : operation.getInputTypes()) {
                if (!DataHandler.class.isAssignableFrom(dataType.getType())) continue;
                return true;
            }
        }
        return false;
    }

    private URI getAdaptorUri(FileBinding definition) throws Fabric3Exception {
        String uri = definition.getAdapterUri();
        if (uri == null) {
            return null;
        }
        try {
            return new URI(this.info.getDomain().toString() + "/" + uri);
        }
        catch (URISyntaxException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }
}

