/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime;

import java.io.File;
import java.io.IOException;
import org.fabric3.api.binding.file.InvalidDataException;
import org.fabric3.api.binding.file.ServiceAdapter;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.InstanceLifecycleException;
import org.oasisopen.sca.ServiceRuntimeException;

public class ServiceAdaptorWrapper
implements ServiceAdapter {
    private AtomicComponent component;

    public ServiceAdaptorWrapper(AtomicComponent component) {
        this.component = component;
    }

    public Object[] beforeInvoke(File file) throws InvalidDataException {
        return this.getInstance().beforeInvoke(file);
    }

    public void afterInvoke(File file, Object[] payload) throws IOException {
        this.getInstance().afterInvoke(file, payload);
    }

    public void error(File file, File errorDirectory, Exception e) throws IOException {
        this.getInstance().error(file, errorDirectory, e);
    }

    public void delete(File file) throws IOException {
        this.getInstance().delete(file);
    }

    public void archive(File file, File archiveDirectory) throws IOException {
        this.getInstance().archive(file, archiveDirectory);
    }

    private ServiceAdapter getInstance() {
        try {
            Object instance = this.component.getInstance();
            if (!(instance instanceof ServiceAdapter)) {
                String componentName = this.component.getName();
                throw new ServiceRuntimeException("File binding adaptor must implement " + ServiceAdapter.class.getName() + ":" + componentName);
            }
            return (ServiceAdapter)instance;
        }
        catch (InstanceLifecycleException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }
}

