/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime;

import java.io.File;
import java.net.URI;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.binding.file.ServiceAdapter;
import org.fabric3.api.binding.file.annotation.Strategy;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.binding.file.provision.FileBindingWireSourceDefinition;
import org.fabric3.binding.file.runtime.DataHandlerServiceAdapter;
import org.fabric3.binding.file.runtime.DefaultServiceAdapter;
import org.fabric3.binding.file.runtime.ServiceAdaptorWrapper;
import org.fabric3.binding.file.runtime.receiver.PassThroughInterceptor;
import org.fabric3.binding.file.runtime.receiver.ReceiverConfiguration;
import org.fabric3.binding.file.runtime.receiver.ReceiverManager;
import org.fabric3.binding.file.runtime.receiver.ReceiverMonitor;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceWireAttacher;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class FileSourceWireAttacher
implements SourceWireAttacher<FileBindingWireSourceDefinition> {
    private static final ServiceAdapter ADAPTER = new DefaultServiceAdapter();
    private static final ServiceAdapter JAF_ADAPTER = new DataHandlerServiceAdapter();
    private ReceiverManager receiverManager;
    private ClassLoaderRegistry registry;
    private ComponentManager manager;
    private ReceiverMonitor monitor;
    private File baseDir;

    public FileSourceWireAttacher(@Reference ReceiverManager receiverManager, @Reference ClassLoaderRegistry registry, @Reference ComponentManager manager, @Reference HostInfo hostInfo, @Monitor ReceiverMonitor monitor) {
        this.receiverManager = receiverManager;
        this.registry = registry;
        this.manager = manager;
        this.monitor = monitor;
        this.baseDir = new File(hostInfo.getDataDir(), "inbox");
    }

    public void attach(FileBindingWireSourceDefinition source, PhysicalWireTargetDefinition target, Wire wire) throws ContainerException {
        String id = source.getUri().toString();
        File location = this.getLocation(source);
        File errorLocation = this.getErrorLocation(source);
        File archiveLocation = this.getArchiveLocation(source);
        String pattern = source.getPattern();
        Strategy strategy = source.getStrategy();
        PassThroughInterceptor interceptor = new PassThroughInterceptor();
        for (InvocationChain chain : wire.getInvocationChains()) {
            chain.addInterceptor((Interceptor)interceptor);
        }
        ServiceAdapter adapter = this.getAdaptor(source);
        long delay = source.getDelay();
        ReceiverConfiguration configuration = new ReceiverConfiguration(id, location, pattern, strategy, errorLocation, archiveLocation, interceptor, adapter, delay, this.monitor);
        this.receiverManager.create(configuration);
    }

    public void detach(FileBindingWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
        String id = source.getUri().toString();
        this.receiverManager.remove(id);
    }

    public void attachObjectFactory(FileBindingWireSourceDefinition source, ObjectFactory<?> objectFactory, PhysicalWireTargetDefinition target) {
        throw new UnsupportedOperationException();
    }

    public void detachObjectFactory(FileBindingWireSourceDefinition source, PhysicalWireTargetDefinition target) {
        throw new UnsupportedOperationException();
    }

    private File getLocation(FileBindingWireSourceDefinition source) {
        String location = source.getLocation();
        return this.resolve(location);
    }

    private File getArchiveLocation(FileBindingWireSourceDefinition source) {
        File archiveLocation = null;
        String archiveLocationStr = source.getArchiveLocation();
        if (archiveLocationStr != null) {
            archiveLocation = this.resolve(archiveLocationStr);
        }
        return archiveLocation;
    }

    private File getErrorLocation(FileBindingWireSourceDefinition source) {
        File errorLocation = null;
        String errorLocationStr = source.getErrorLocation();
        if (errorLocationStr != null) {
            errorLocation = this.resolve(errorLocationStr);
        }
        return errorLocation;
    }

    private File resolve(String location) {
        File file = new File(location);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.baseDir, location);
    }

    private ServiceAdapter getAdaptor(FileBindingWireSourceDefinition source) throws ContainerException {
        String adapterClass = source.getAdapterClass();
        if (adapterClass == null) {
            URI adapterUri = source.getAdapterUri();
            if (adapterUri == null) {
                return source.isDataHandler() ? JAF_ADAPTER : ADAPTER;
            }
            Component component = this.manager.getComponent(adapterUri);
            if (component == null) {
                throw new ContainerException("Binding adaptor component not found: " + adapterUri);
            }
            if (!(component instanceof AtomicComponent)) {
                throw new ContainerException("Adaptor component must implement " + AtomicComponent.class.getName() + ": " + adapterUri);
            }
            return new ServiceAdaptorWrapper((AtomicComponent)component);
        }
        URI uri = source.getClassLoaderId();
        ClassLoader loader = this.registry.getClassLoader(uri);
        if (loader == null) {
            throw new ContainerException("ClassLoader not found: " + uri);
        }
        try {
            return (ServiceAdapter)loader.loadClass(adapterClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ContainerException((Throwable)e);
        }
    }
}

