/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.packager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class Fabric3PackagerMojo
extends AbstractMojo {
    public static final String F3_ARTIFACT_ID = "org.fabric3";
    public static final String F3_EXTENSIONS_JAR = "f3.extensions.jar";
    private static final int BUFFER = 2048;
    public File buildDirectory;
    public String warName;
    public String runtimeVersion;
    public Dependency[] profiles = new Dependency[0];
    public Dependency[] extensions = new Dependency[0];
    public RepositorySystem repositorySystem;
    public RepositorySystemSession session;

    public void execute() throws MojoExecutionException {
        this.addDefaultExtensions();
        File libDirectory = new File(this.buildDirectory, this.warName + File.separator + "WEB-INF" + File.separator + "lib");
        libDirectory.mkdirs();
        File stagingDirectory = new File(this.buildDirectory, "f3");
        stagingDirectory.mkdirs();
        File extensionsDirectory = new File(stagingDirectory, "extensions");
        extensionsDirectory.mkdir();
        this.extractProfiles(stagingDirectory);
        this.resolveDependencies(this.extensions, extensionsDirectory);
        this.createExtensionsArchive(extensionsDirectory, libDirectory);
        Dependency[] dependencies = new Dependency[2];
        dependencies[0] = new Dependency();
        dependencies[0].setGroupId(F3_ARTIFACT_ID);
        dependencies[0].setArtifactId("fabric3-node");
        dependencies[0].setVersion(this.runtimeVersion);
        dependencies[1] = new Dependency();
        dependencies[1].setGroupId(F3_ARTIFACT_ID);
        dependencies[1].setArtifactId("fabric3-node-extensions");
        dependencies[1].setVersion(this.runtimeVersion);
        this.resolveDependencies(dependencies, libDirectory);
    }

    private void addDefaultExtensions() {
        int length = this.extensions.length;
        this.extensions = Arrays.copyOf(this.extensions, length + 2);
        this.extensions[length] = new Dependency();
        this.extensions[length].setGroupId(F3_ARTIFACT_ID);
        this.extensions[length].setArtifactId("fabric3-databinding-json");
        this.extensions[length].setVersion(this.runtimeVersion);
    }

    private void extractProfiles(File extensionsDirectory) throws MojoExecutionException {
        for (Dependency profile : this.profiles) {
            String groupId = profile.getGroupId();
            String artifactId = profile.getArtifactId();
            String version = profile.getVersion();
            this.getLog().info((CharSequence)("Resolving profile: " + groupId + ":" + artifactId));
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "bin", "zip", version);
            try {
                ArtifactResult result = this.repositorySystem.resolveArtifact(this.session, new ArtifactRequest((Artifact)artifact, null, null));
                File source = result.getArtifact().getFile();
                this.extract(source, extensionsDirectory);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private void resolveDependencies(Dependency[] dependencies, File targetDirectory) throws MojoExecutionException {
        for (Dependency extension : dependencies) {
            ArtifactResult result;
            String groupId = extension.getGroupId();
            String artifactId = extension.getArtifactId();
            String version = extension.getVersion();
            String type = extension.getType();
            String classifier = extension.getClassifier();
            this.getLog().info((CharSequence)("Resolving dependency: " + groupId + ":" + artifactId));
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, type, version);
            try {
                result = this.repositorySystem.resolveArtifact(this.session, new ArtifactRequest((Artifact)artifact, null, null));
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            File source = result.getArtifact().getFile();
            BufferedInputStream sourceStream = null;
            BufferedOutputStream targetStream = null;
            try {
                sourceStream = new BufferedInputStream(new FileInputStream(source));
                File targetFile = new File(targetDirectory, source.getName());
                targetStream = new BufferedOutputStream(new FileOutputStream(targetFile));
                this.copy(sourceStream, targetStream);
                this.close(targetStream);
                this.close(sourceStream);
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                catch (Throwable throwable) {
                    this.close(targetStream);
                    this.close(sourceStream);
                    throw throwable;
                }
            }
        }
    }

    private void extract(File source, File destination) throws MojoExecutionException {
        ZipFile zipfile;
        try {
            zipfile = new ZipFile(source);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (entry.isDirectory()) {
                new File(destination, entry.getName()).mkdirs();
                continue;
            }
            if (entry.getName().toUpperCase().endsWith(".MF")) continue;
            BufferedInputStream sourceStream = null;
            BufferedOutputStream targetStream = null;
            try {
                sourceStream = new BufferedInputStream(zipfile.getInputStream(entry));
                FileOutputStream fos = new FileOutputStream(new File(destination, entry.getName()));
                targetStream = new BufferedOutputStream(fos, 2048);
                this.copy(sourceStream, targetStream);
                ((OutputStream)targetStream).flush();
                this.close(targetStream);
                this.close(sourceStream);
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                catch (Throwable throwable) {
                    this.close(targetStream);
                    this.close(sourceStream);
                    throw throwable;
                }
            }
        }
    }

    private void createExtensionsArchive(File extensionsDirectory, File libDirectory) throws MojoExecutionException {
        JarOutputStream jarStream = null;
        try {
            File archive = new File(libDirectory, F3_EXTENSIONS_JAR);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(archive));
            jarStream = new JarOutputStream(os);
            for (File file : extensionsDirectory.listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                JarEntry entry = new JarEntry(file.getName());
                jarStream.putNextEntry(entry);
                this.copy(new FileInputStream(file), jarStream);
            }
            jarStream.flush();
            this.close(jarStream);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                this.close(jarStream);
                throw throwable;
            }
        }
    }

    private int copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[2048];
        int count = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    private void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }
}

