/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.fun;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.value.SequenceType;
import org.expath.tools.ToolsException;
import org.expath.tools.saxon.fun.Definition;
import org.expath.tools.saxon.fun.Function;
import org.expath.tools.saxon.fun.Library;
import org.expath.tools.saxon.fun.Param;

public class DefBuilder {
    private final Function myCall;
    private final StructuredQName myName;
    private final List<Param> myParams;
    private final Library myLib;
    private boolean myOptional;
    private SequenceType myResult;
    private static final Param[] MARKER = new Param[0];

    public DefBuilder(Function call, StructuredQName name, Library lib) {
        this.myCall = call;
        this.myName = name;
        this.myOptional = false;
        this.myParams = new ArrayList<Param>();
        this.myLib = lib;
    }

    public DefBuilder returns(SequenceType type) {
        this.myResult = type;
        return this;
    }

    public DefBuilder optional() throws ToolsException {
        if (this.myOptional) {
            throw new ToolsException("Cannot call optional() twice on the same DefBuilder");
        }
        this.myOptional = true;
        return this;
    }

    public DefBuilder param(SequenceType type, String name) {
        Param p = new Param(type, name, this.myOptional);
        this.myParams.add(p);
        return this;
    }

    public Definition make() throws ToolsException {
        if (null == this.myResult) {
            throw new ToolsException("Result type has not been set on DefBuilder");
        }
        Definition def = new Definition(this.myCall, this.myName, this.myResult, this.myParams.toArray(MARKER));
        this.myLib.addDef(this.myName, def);
        return def;
    }
}

