/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.model;

import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import org.expath.tools.ToolsException;
import org.expath.tools.model.TreeBuilder;

public class SaxonTreeBuilder
implements TreeBuilder {
    private Builder myBuilder;
    private String myNs;
    private String myPrefix;

    public SaxonTreeBuilder(XPathContext ctxt, String prefix, String ns) throws ToolsException {
        this.myBuilder = ctxt.getController().makeBuilder();
        this.myBuilder.open();
        this.myNs = ns;
        this.myPrefix = prefix;
    }

    public NodeInfo getCurrentRoot() throws ToolsException {
        try {
            this.myBuilder.close();
        }
        catch (XPathException ex) {
            throw new ToolsException("Error closing the Saxon tree builder", (Throwable)ex);
        }
        return this.myBuilder.getCurrentRoot();
    }

    public void startElem(String localname) throws ToolsException {
        FingerprintedQName name = new FingerprintedQName(this.myPrefix, this.myNs, localname);
        try {
            this.myBuilder.startElement((NodeName)name, (SchemaType)Untyped.getInstance(), (Location)new ExplicitLocation(null, 0, 0), 0);
        }
        catch (XPathException ex) {
            throw new ToolsException("Error starting element on the Saxon tree builder", (Throwable)ex);
        }
    }

    public void attribute(String localname, CharSequence value) throws ToolsException {
        if (value != null) {
            NoNamespaceName name = new NoNamespaceName(localname);
            try {
                this.myBuilder.attribute((NodeName)name, (SimpleType)BuiltInAtomicType.UNTYPED_ATOMIC, value, null, 0);
            }
            catch (XPathException ex) {
                throw new ToolsException("Error creating attribute on the Saxon tree builder", (Throwable)ex);
            }
        }
    }

    public void startContent() throws ToolsException {
        try {
            this.myBuilder.startContent();
        }
        catch (XPathException ex) {
            throw new ToolsException("Error starting content on the Saxon tree builder", (Throwable)ex);
        }
    }

    public void endElem() throws ToolsException {
        try {
            this.myBuilder.endElement();
        }
        catch (XPathException ex) {
            throw new ToolsException("Error ending element on the Saxon tree builder", (Throwable)ex);
        }
    }
}

