/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.fun;

import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;

public class Return {
    public static Sequence empty() {
        return EmptySequence.getInstance();
    }

    public static Sequence value(XdmNode node) {
        return Return.node(node);
    }

    public static Sequence value(XdmValue value) {
        return Return.item(value);
    }

    public static Sequence value(byte[] bytes) {
        return Return.binary(bytes);
    }

    public static Sequence value(Boolean b) {
        return Return.bool(b);
    }

    public static Sequence value(String string) {
        return Return.string(string);
    }

    public static Sequence value(Iterable<String> strings) {
        return Return.stringList(strings);
    }

    public static Sequence value(Date date) {
        return Return.dateTime(date, false);
    }

    public static Sequence value(Date date, boolean tz) {
        return Return.dateTime(date, tz);
    }

    public static Sequence value(Calendar dt) {
        return Return.dateTime(dt, false);
    }

    public static Sequence value(Calendar dt, boolean tz) {
        return Return.dateTime(dt, tz);
    }

    public static Sequence value(Long i) {
        return Return.integer(i);
    }

    public static Sequence value(BigInteger i) {
        return Return.integer(i);
    }

    public static Sequence value(URI uri) {
        return Return.uri(uri);
    }

    public static Sequence node(XdmNode node) {
        if (node == null) {
            return Return.empty();
        }
        return node.getUnderlyingNode();
    }

    public static Sequence item(XdmValue value) {
        if (value == null) {
            return Return.empty();
        }
        return value.getUnderlyingValue();
    }

    public static Sequence binary(byte[] bytes) {
        if (bytes == null) {
            return Return.empty();
        }
        return new Base64BinaryValue(bytes);
    }

    public static Sequence bool(Boolean b) {
        if (b == null) {
            return Return.empty();
        }
        if (b.booleanValue()) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    public static Sequence string(String string) {
        if (string == null) {
            return Return.empty();
        }
        return new StringValue((CharSequence)string);
    }

    public static Sequence stringList(Iterable<String> strings) {
        if (strings == null) {
            return Return.empty();
        }
        ArrayList<StringValue> items = new ArrayList<StringValue>();
        for (String s : strings) {
            StringValue v = new StringValue((CharSequence)s);
            items.add(v);
        }
        if (items.isEmpty()) {
            return Return.empty();
        }
        return new AtomicArray(items);
    }

    public static Sequence dateTime(Date date, boolean tz) {
        if (date == null) {
            return Return.empty();
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return Return.dateTime(cal, tz);
    }

    public static Sequence dateTime(Calendar dt, boolean tz) {
        if (dt == null) {
            return Return.empty();
        }
        return new DateTimeValue(dt, tz);
    }

    public static Sequence date(Date date) {
        if (date == null) {
            return Return.empty();
        }
        return new DateValue(date.getYear(), (byte)date.getMonth(), (byte)date.getDay());
    }

    public static Sequence date(Calendar date, boolean tz) {
        if (date == null) {
            return Return.empty();
        }
        return new DateValue(date.get(1), (byte)date.get(2), (byte)date.get(5));
    }

    public static Sequence integer(Long i) {
        if (i == null) {
            return Return.empty();
        }
        return new Int64Value(i.longValue());
    }

    public static Sequence integer(BigInteger i) {
        if (i == null) {
            return Return.empty();
        }
        return new BigIntegerValue(i);
    }

    public static Sequence uri(URI uri) {
        if (uri == null) {
            return Return.empty();
        }
        return new AnyURIValue((CharSequence)uri.toASCIIString());
    }
}

