/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import org.exparity.hamcrest.date.core.TemporalConverter;
import org.exparity.hamcrest.date.core.TemporalFunction;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProvider;
import org.hamcrest.Description;

public class IsAfter<T, E>
extends TemporalMatcher<T> {
    private final TemporalProvider<E> expected;
    private final TemporalConverter<T, E> converter;
    private final TemporalFunction<E> functions;
    private final Locale locale;
    private final Optional<ZoneId> zone;

    public IsAfter(TemporalConverter<T, E> converter, TemporalProvider<E> expected, TemporalFunction<E> functions, Optional<ZoneId> zone, Locale locale) {
        this.expected = expected;
        this.converter = converter;
        this.functions = functions;
        this.locale = locale;
        this.zone = zone;
    }

    public IsAfter(TemporalConverter<T, E> converter, TemporalProvider<E> expected, TemporalFunction<E> functions) {
        this(converter, expected, functions, Optional.empty(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        E actualValue;
        E expectedValue = this.expected.apply(this.zone);
        if (this.functions.isSame(expectedValue, actualValue = this.converter.apply(actual, this.zone)) || this.functions.isAfter(expectedValue, actualValue)) {
            mismatchDescription.appendText("date is " + this.functions.describe(actualValue, this.locale));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is after " + this.functions.describe(this.expected.apply(this.zone), this.locale));
    }

    @Override
    public TemporalMatcher<T> atZone(ZoneId zone) {
        return new IsAfter<T, E>(this.converter, this.expected, this.functions, Optional.of(zone), this.locale);
    }

    @Override
    public TemporalMatcher<T> atLocale(Locale locale) {
        return new IsAfter<T, E>(this.converter, this.expected, this.functions, this.zone, locale);
    }
}

