/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.proxy;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.common.http.client.Codecs;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.common.http.client.ProtocolNotSuppException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.proxy.Connector;

public class BaseConnector
extends Connector {
    private HTTPConnection conn;
    HTTPResponse resp = null;
    NVPair[] form_data;
    NVPair[] headers;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.ext.BaseConnector");

    public HTTPResponse fetchGet(HttpServletRequest httpRequest, String url) throws MalformedURLException, ProtocolNotSuppException, IOException, ModuleException, ParseException {
        URL url_obj = null;
        url_obj = new URL(url);
        this.conn = new HTTPConnection(url_obj);
        this.conn.setTimeout(5000);
        this.prepareRequestHeaders(httpRequest);
        this.prepareFormParams(url_obj);
        this.conn.setAllowUserInteraction(false);
        this.resp = this.conn.Get(url_obj.getProtocol() + "://" + url_obj.getAuthority() + url_obj.getPath(), this.form_data, this.headers);
        if (this.resp.getStatusCode() >= 300) {
            LOG.error((Object)("Received Error: " + this.resp.getReasonLine()));
            LOG.error((Object)this.resp.getText());
        }
        return this.resp;
    }

    public HTTPResponse fetchPost(HttpServletRequest httpRequest, String url) throws MalformedURLException, ProtocolNotSuppException, IOException, ModuleException, ParseException {
        URL url_obj = null;
        url_obj = new URL(url);
        this.conn = new HTTPConnection(url_obj);
        this.conn.setTimeout(5000);
        this.conn.setAllowUserInteraction(false);
        this.prepareRequestHeaders(httpRequest);
        byte[] body = new byte[httpRequest.getContentLength()];
        new DataInputStream((InputStream)httpRequest.getInputStream()).readFully(body);
        this.resp = this.conn.Post(url_obj.getProtocol() + "://" + url_obj.getAuthority() + url_obj.getPath(), body, this.headers);
        if (this.resp.getStatusCode() >= 300) {
            LOG.error((Object)("Received Error: " + this.resp.getReasonLine()));
            LOG.error((Object)this.resp.getText());
        }
        return this.resp;
    }

    public HTTPResponse doPut(HttpServletRequest httpRequest, String url) throws MalformedURLException, ProtocolNotSuppException, IOException, ModuleException, ParseException {
        URL url_obj = null;
        url_obj = new URL(url);
        this.conn = new HTTPConnection(url_obj);
        this.conn.setTimeout(5000);
        this.conn.setAllowUserInteraction(false);
        this.prepareRequestHeaders(httpRequest);
        byte[] body = new byte[httpRequest.getContentLength()];
        new DataInputStream((InputStream)httpRequest.getInputStream()).readFully(body);
        this.resp = this.conn.Put(url_obj.getProtocol() + "://" + url_obj.getAuthority() + url_obj.getPath(), body, this.headers);
        if (this.resp.getStatusCode() >= 300) {
            LOG.error((Object)("Received Error: " + this.resp.getReasonLine()));
            LOG.error((Object)this.resp.getText());
        }
        return this.resp;
    }

    public HTTPResponse doDelete(HttpServletRequest httpRequest, String url) throws MalformedURLException, ProtocolNotSuppException, IOException, ModuleException, ParseException {
        URL url_obj = null;
        url_obj = new URL(url);
        this.conn = new HTTPConnection(url_obj);
        this.conn.setTimeout(5000);
        this.conn.setAllowUserInteraction(false);
        this.prepareRequestHeaders(httpRequest);
        this.resp = this.conn.Delete(url_obj.getProtocol() + "://" + url_obj.getAuthority() + url_obj.getPath(), this.headers);
        if (this.resp.getStatusCode() >= 300) {
            LOG.error((Object)("Received Error: " + this.resp.getReasonLine()));
            LOG.error((Object)this.resp.getText());
        }
        return this.resp;
    }

    private void prepareRequestHeaders(HttpServletRequest httpRequest) {
        ArrayList<NVPair> hds = new ArrayList<NVPair>();
        Enumeration en = httpRequest.getHeaderNames();
        while (en.hasMoreElements()) {
            NVPair pair = null;
            String headerName = (String)en.nextElement();
            if (headerName.equalsIgnoreCase("Host")) continue;
            Enumeration en2 = httpRequest.getHeaders(headerName);
            while (en2.hasMoreElements()) {
                pair = new NVPair(headerName, (String)en2.nextElement());
            }
            hds.add(pair);
            this.headers = new NVPair[hds.size()];
            this.headers = hds.toArray(this.headers);
        }
    }

    private void prepareFormParams(URL url) {
        String query = url.getQuery();
        if (query != null) {
            try {
                this.form_data = Codecs.query2nv((String)query);
            }
            catch (ParseException e) {
                LOG.error((Object)e.getMessage());
            }
        }
    }
}

