/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.test.mocks.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.test.mocks.servlet.MockPrincipal;

public class MockServletRequest
implements HttpServletRequest {
    private Map parameters;
    private Map attributes;
    private HttpSession session;
    private Locale locale;
    private boolean secure;
    private Map headers;
    private String enc = "ISO-8859-1";
    private String pathInfo_;
    private String requestURI_;
    private URL url;
    private String method = "GET";
    private String contextPath = "";
    private String remoteUser = "REMOTE USER FROM MOCK";

    public MockServletRequest(HttpSession session, Locale locale) {
        this(session, locale, false);
    }

    public MockServletRequest(HttpSession session, Locale locale, boolean secure) {
        this(session, null, null, locale, secure);
    }

    public MockServletRequest(HttpSession session, URL url, String contextPath, Locale locale, boolean secure) {
        this.session = session;
        this.locale = locale;
        this.headers = new HashMap();
        ArrayList<String> headersMultiple = new ArrayList<String>();
        headersMultiple.add("header-value3-1");
        headersMultiple.add("header-value3-2");
        headersMultiple.add("header-value3-3");
        this.headers.put("header1", "header-value1");
        this.headers.put("header2", "header-value2");
        this.headers.put("header3", headersMultiple);
        this.parameters = new HashMap();
        this.attributes = new HashMap();
        this.secure = secure;
        if (url == null) {
            try {
                this.url = new URL("http://exoplatform.com:80/context/path?q=v");
                this.contextPath = "/context";
            }
            catch (MalformedURLException e) {}
        } else {
            this.url = url;
            this.contextPath = contextPath;
        }
    }

    public void reset() {
        this.parameters = new HashMap();
        this.attributes = new HashMap();
    }

    public String getAuthType() {
        return "DIGEST";
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String s) {
        return 0L;
    }

    public String getHeader(String s) {
        return (String)this.headers.get(s);
    }

    public Enumeration getHeaders(String s) {
        if (this.headers.get(s) instanceof Collection) {
            return Collections.enumeration((Collection)this.headers.get(s));
        }
        Vector v = new Vector();
        v.add(this.headers.get(s));
        return v.elements();
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String s) {
        return 0;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo_;
    }

    public void setPathInfo(String s) {
        this.pathInfo_ = s;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.url.getQuery();
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public boolean isUserInRole(String s) {
        return "auth-user".equals(s);
    }

    public Principal getUserPrincipal() {
        return new MockPrincipal();
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        if (this.requestURI_ == null) {
            return this.url.getPath();
        }
        return this.requestURI_;
    }

    public void setRequestURI(String s) {
        this.requestURI_ = s;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.url.toString());
    }

    public String getServletPath() {
        return this.url.getPath();
    }

    public HttpSession getSession(boolean b) {
        return this.session;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration getAttributeNames() {
        return new Vector(this.attributes.keySet()).elements();
    }

    public String getCharacterEncoding() {
        return this.enc;
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        this.enc = s;
    }

    public int getContentLength() {
        return 0;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String s) {
        return (String)this.parameters.get(s);
    }

    public void setParameter(String s, Object value) {
        this.parameters.put(s, value);
    }

    public Enumeration getParameterNames() {
        return new Vector(this.parameters.keySet()).elements();
    }

    public String[] getParameterValues(String s) {
        ArrayList<String> arr = new ArrayList<String>();
        for (String pname : this.parameters.keySet()) {
            if (!pname.equals(s)) continue;
            arr.add((String)this.parameters.get(s));
        }
        return arr.toArray(new String[arr.size()]);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public String getProtocol() {
        return null;
    }

    public String getScheme() {
        return this.url.getProtocol();
    }

    public String getServerName() {
        return this.url.getHost();
    }

    public int getServerPort() {
        return this.url.getPort();
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String s, Object o) {
        this.attributes.put(s, o);
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getLocales() {
        System.out.println("MOCK get Locale : " + this.locale);
        Vector<Locale> v = new Vector<Locale>();
        v.add(this.locale);
        return v.elements();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public String getRealPath(String s) {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getLocalAddr() {
        return "127.0.0.1";
    }

    public String getLocalName() {
        return "localhost";
    }

    public int getRemotePort() {
        return 0;
    }
}

