/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.context;

import java.lang.annotation.Annotation;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.servlet.ServletRequest;
import org.exoplatform.container.context.CreationContext;
import org.exoplatform.container.context.CreationContextStorage;
import org.exoplatform.container.context.UnSharedContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestContext
extends UnSharedContext<ServletRequest> {
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    @Override
    protected CreationContextStorage createStorage(ServletRequest key) {
        return new RequestContextStorage(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RequestContextStorage
    implements CreationContextStorage {
        private static final String PREFIX = RequestContextStorage.class.getPackage().getName();
        private final ServletRequest request;

        public RequestContextStorage(ServletRequest request) {
            this.request = request;
        }

        private String getFullId(String id) {
            StringBuilder sb = new StringBuilder(PREFIX);
            sb.append('#');
            sb.append(id);
            return sb.toString();
        }

        @Override
        public String getId() {
            return "RequestContextStorage";
        }

        @Override
        public <T> T setInstance(String id, CreationContext<T> creationContext) {
            String fullId = this.getFullId(id);
            CreationContext currentValue = (CreationContext)this.request.getAttribute(fullId);
            if (currentValue != null && currentValue.getInstance() != null) {
                return currentValue.getInstance();
            }
            this.request.setAttribute(fullId, creationContext);
            return creationContext.getInstance();
        }

        @Override
        public <T> CreationContext<T> getCreationContext(String id) {
            String fullId = this.getFullId(id);
            return (CreationContext)this.request.getAttribute(fullId);
        }

        @Override
        public void removeInstance(String id) {
            String fullId = this.getFullId(id);
            this.request.removeAttribute(fullId);
        }

        @Override
        public Set<String> getAllIds() {
            Enumeration enumeration = this.request.getAttributeNames();
            HashSet<String> ids = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                String id = (String)enumeration.nextElement();
                if (!id.startsWith(PREFIX)) continue;
                ids.add(id.substring(PREFIX.length() + 1));
            }
            return ids;
        }
    }
}

