/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.xml.object;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.xml.object.XMLCollection;
import org.exoplatform.xml.object.XMLMap;
import org.exoplatform.xml.object.XMLNativeArray;
import org.exoplatform.xml.object.XMLObject;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class XMLBaseObject {
    public static final String STRING = "string";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String BOOLEAN = "boolean";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String DATE = "date";
    public static final String MAP = "map";
    public static final String COLLECTION = "collection";
    public static final String ARRAY = "array";
    public static final String NATIVE_ARRAY = "native-array";
    public static final String OBJECT = "object";
    protected String type;
    protected Object value;
    public static final String JiBX_bindingList = "|org.exoplatform.container.xml.JiBX_bindingFactory|";

    public XMLBaseObject() {
    }

    public XMLBaseObject(Class objecttype, Object val) throws Exception {
        if (val == null) {
            this.setType(objecttype);
        } else {
            this.setObjectValue(val);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String s) {
        this.type = s;
    }

    public void setType(Class clazz) {
        this.type = String.class.equals((Object)clazz) ? STRING : (Integer.class.equals((Object)clazz) ? INT : (Long.class.equals((Object)clazz) ? LONG : (Float.class.equals((Object)clazz) ? FLOAT : (Double.class.equals((Object)clazz) ? DOUBLE : (Boolean.class.equals((Object)clazz) ? BOOLEAN : (Date.class.equals((Object)clazz) ? DATE : (Map.class.equals((Object)clazz) ? MAP : (Collection.class.equals((Object)clazz) ? COLLECTION : (XMLNativeArray.isNativeArray(clazz) ? NATIVE_ARRAY : OBJECT)))))))));
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object v) {
        this.value = v;
    }

    public Object getObjectValue() throws Exception {
        if (this.value instanceof XMLCollection) {
            return ((XMLCollection)this.value).getCollection();
        }
        if (this.value instanceof XMLMap) {
            return ((XMLMap)this.value).getMap();
        }
        if (this.value instanceof XMLNativeArray) {
            return ((XMLNativeArray)this.value).getValue();
        }
        if (this.value instanceof XMLObject) {
            return ((XMLObject)this.value).toObject();
        }
        return this.value;
    }

    public void setObjectValue(Object o) throws Exception {
        if (o instanceof String) {
            this.setString((String)o);
        } else if (o instanceof Integer) {
            this.setInt((Integer)o);
        } else if (o instanceof Long) {
            this.setLong((Long)o);
        } else if (o instanceof Float) {
            this.setFloat((Float)o);
        } else if (o instanceof Double) {
            this.setDouble((Double)o);
        } else if (o instanceof Boolean) {
            this.setBoolean((Boolean)o);
        } else if (o instanceof Date) {
            this.setDate((Date)o);
        } else if (o instanceof Map) {
            this.setMapValue((Map)o);
        } else if (o instanceof Collection) {
            this.setCollectiontValue((Collection)o);
        } else if (o instanceof XMLObject) {
            this.setObject((XMLObject)o);
        } else if (XMLNativeArray.isNativeArray(o)) {
            this.setNativeArrayValue(o);
        } else {
            this.setObject(new XMLObject(o));
        }
    }

    public XMLObject getObject() {
        if (this.value instanceof XMLObject) {
            return (XMLObject)this.value;
        }
        return null;
    }

    public void setObject(XMLObject o) {
        if (o == null) {
            return;
        }
        this.type = OBJECT;
        this.value = o;
    }

    public String getString() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return null;
    }

    public void setString(String s) {
        if (s == null) {
            return;
        }
        this.type = STRING;
        this.value = s;
    }

    public Integer getInt() {
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        return null;
    }

    public void setInt(Integer i) {
        if (i == null) {
            return;
        }
        this.type = INT;
        this.value = i;
    }

    public Long getLong() {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        return null;
    }

    public void setLong(Long l) {
        if (l == null) {
            return;
        }
        this.type = LONG;
        this.value = l;
    }

    public Float getFloat() {
        if (this.value instanceof Float) {
            return (Float)this.value;
        }
        return null;
    }

    public void setFloat(Float f) {
        if (f == null) {
            return;
        }
        this.type = DOUBLE;
        this.value = f;
    }

    public Double getDouble() {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        return null;
    }

    public void setDouble(Double d) {
        if (d == null) {
            return;
        }
        this.type = FLOAT;
        this.value = d;
    }

    public Boolean getBoolean() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return null;
    }

    public void setBoolean(Boolean b) {
        if (b == null) {
            return;
        }
        this.type = BOOLEAN;
        this.value = b;
    }

    public Date getDate() {
        if (this.value instanceof Date) {
            return (Date)this.value;
        }
        return null;
    }

    public void setDate(Date date) {
        if (date == null) {
            return;
        }
        this.type = DATE;
        this.value = date;
    }

    public XMLMap getMap() {
        if (this.value instanceof XMLMap) {
            return (XMLMap)this.value;
        }
        return null;
    }

    public void setMapValue(Map map) throws Exception {
        if (map == null) {
            return;
        }
        this.type = MAP;
        this.value = new XMLMap(map);
    }

    public void setMap(XMLMap map) {
        if (map == null) {
            return;
        }
        this.type = MAP;
        this.value = map;
    }

    public XMLCollection getCollection() {
        if (this.value instanceof XMLCollection) {
            return (XMLCollection)this.value;
        }
        return null;
    }

    public void setCollectiontValue(Collection collection) throws Exception {
        if (collection == null) {
            return;
        }
        this.type = COLLECTION;
        this.value = new XMLCollection(collection);
    }

    public void setCollection(XMLCollection collection) {
        if (collection == null) {
            return;
        }
        this.type = COLLECTION;
        this.value = collection;
    }

    public XMLNativeArray getNativeArray() {
        if (this.value instanceof XMLNativeArray) {
            return (XMLNativeArray)this.value;
        }
        return null;
    }

    public void setNativeArrayValue(Object array) throws Exception {
        if (array == null) {
            return;
        }
        this.type = NATIVE_ARRAY;
        this.value = new XMLNativeArray(array);
    }

    public void setNativeArray(XMLNativeArray array) {
        if (array == null) {
            return;
        }
        this.type = NATIVE_ARRAY;
        this.value = array;
    }

    public static /* synthetic */ XMLBaseObject JiBX_binding_unmarshal_1_0(XMLBaseObject arg1, UnmarshallingContext arg2) throws JiBXException {
        try {
            arg2.pushTrackedObject((Object)arg1);
            XMLBaseObject xMLBaseObject = arg1;
            String string = arg2.parseElementText(null, STRING, null);
            arg1.setString((String)(string == null ? null : Deserializer.resolveString(string)));
            String string2 = arg2.parseElementText(null, INT, null);
            arg1.setInt((Integer)(string2 == null ? null : Deserializer.resolveInteger(string2)));
            String string3 = arg2.parseElementText(null, LONG, null);
            arg1.setLong((Long)(string3 == null ? null : Deserializer.resolveLong(string3)));
            String string4 = arg2.parseElementText(null, DOUBLE, null);
            arg1.setDouble((Double)(string4 == null ? null : Deserializer.resolveDouble(string4)));
            String string5 = arg2.parseElementText(null, BOOLEAN, null);
            arg1.setBoolean((Boolean)(string5 == null ? null : Deserializer.resolveBoolean(string5)));
            String string6 = arg2.parseElementText(null, DATE, null);
            arg1.setDate((Date)(string6 == null ? null : Utility.deserializeDateTime((String)string6)));
            arg1.setMap(!arg2.getUnmarshaller("org.exoplatform.xml.object.XMLMap").isPresent((IUnmarshallingContext)arg2) ? null : (XMLMap)arg2.getUnmarshaller("org.exoplatform.xml.object.XMLMap").unmarshal((Object)arg1.getMap(), (IUnmarshallingContext)arg2));
            arg1.setCollection(!arg2.getUnmarshaller("org.exoplatform.xml.object.XMLCollection").isPresent((IUnmarshallingContext)arg2) ? null : (XMLCollection)arg2.getUnmarshaller("org.exoplatform.xml.object.XMLCollection").unmarshal((Object)arg1.getCollection(), (IUnmarshallingContext)arg2));
            arg1.setNativeArray(!arg2.getUnmarshaller("org.exoplatform.xml.object.XMLNativeArray").isPresent((IUnmarshallingContext)arg2) ? null : (XMLNativeArray)arg2.getUnmarshaller("org.exoplatform.xml.object.XMLNativeArray").unmarshal((Object)arg1.getNativeArray(), (IUnmarshallingContext)arg2));
            arg1.setObject(!arg2.getUnmarshaller("org.exoplatform.xml.object.XMLObject").isPresent((IUnmarshallingContext)arg2) ? null : (XMLObject)arg2.getUnmarshaller("org.exoplatform.xml.object.XMLObject").unmarshal((Object)arg1.getObject(), (IUnmarshallingContext)arg2));
            arg2.popObject();
            return arg1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JiBXException(new StringBuffer("Error while unmarshalling ").append(arg2.buildPositionString()).toString(), (Throwable)illegalArgumentException);
        }
    }

    public static /* synthetic */ void JiBX_binding_marshal_1_0(XMLBaseObject arg1, MarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        MarshallingContext marshallingContext = arg2;
        if (arg1.getString() != null) {
            marshallingContext = marshallingContext.element(0, STRING, arg1.getString());
        }
        if (arg1.getInt() != null) {
            marshallingContext = marshallingContext.element(0, INT, arg1.getInt().toString());
        }
        if (arg1.getLong() != null) {
            marshallingContext = marshallingContext.element(0, LONG, arg1.getLong().toString());
        }
        if (arg1.getDouble() != null) {
            marshallingContext = marshallingContext.element(0, DOUBLE, arg1.getDouble().toString());
        }
        if (arg1.getBoolean() != null) {
            marshallingContext = marshallingContext.element(0, BOOLEAN, Utility.serializeBoolean((Boolean)arg1.getBoolean()));
        }
        if (arg1.getDate() != null) {
            marshallingContext = marshallingContext.element(0, DATE, Utility.serializeDateTime((Date)arg1.getDate()));
        }
        if (arg1.getMap() != null) {
            arg2.getMarshaller("org.exoplatform.xml.object.XMLMap").marshal((Object)arg1.getMap(), (IMarshallingContext)arg2);
        }
        if (arg1.getCollection() != null) {
            arg2.getMarshaller("org.exoplatform.xml.object.XMLCollection").marshal((Object)arg1.getCollection(), (IMarshallingContext)arg2);
        }
        if (arg1.getNativeArray() != null) {
            arg2.getMarshaller("org.exoplatform.xml.object.XMLNativeArray").marshal((Object)arg1.getNativeArray(), (IMarshallingContext)arg2);
        }
        if (arg1.getObject() != null) {
            arg2.getMarshaller("org.exoplatform.xml.object.XMLObject").marshal((Object)arg1.getObject(), (IMarshallingContext)arg2);
        }
        arg2.popObject();
    }

    public static /* synthetic */ XMLBaseObject JiBX_binding_newinstance_1_0(XMLBaseObject arg1, UnmarshallingContext arg2) throws JiBXException {
        if (arg1 == null) {
            arg1 = new XMLBaseObject();
        }
        return arg1;
    }

    public static /* synthetic */ boolean JiBX_binding_test_1_0(UnmarshallingContext arg1) throws JiBXException {
        return arg1.isAt(null, STRING) || arg1.isAt(null, INT) || arg1.isAt(null, LONG) || arg1.isAt(null, DOUBLE) || arg1.isAt(null, BOOLEAN) || arg1.isAt(null, DATE) || arg1.getUnmarshaller("org.exoplatform.xml.object.XMLMap").isPresent((IUnmarshallingContext)arg1) || arg1.getUnmarshaller("org.exoplatform.xml.object.XMLCollection").isPresent((IUnmarshallingContext)arg1) || arg1.getUnmarshaller("org.exoplatform.xml.object.XMLNativeArray").isPresent((IUnmarshallingContext)arg1) || arg1.getUnmarshaller("org.exoplatform.xml.object.XMLObject").isPresent((IUnmarshallingContext)arg1);
    }
}

