/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ExoExpression {
    protected static final int EOF = -1;
    protected static final int BUFFER = 2048;
    public static String entryName;
    public static String outFileName;
    public static String pathOut;

    public ByteArrayInputStream ZipExcute(InputStream is) throws Exception {
        int c;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream out = new BufferedOutputStream(baos);
        while ((c = bis.read()) != -1) {
            out.write((byte)c);
        }
        bis.close();
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return this.getZipOutputStream(bais);
    }

    public ByteArrayInputStream ZipExcute(File file) throws Exception {
        ByteArrayInputStream bais;
        if (file.isDirectory()) {
            bais = this.getZipByteToFolder(file, true);
        } else {
            ExoExpression.setEntry(file.getName());
            FileInputStream is = new FileInputStream(file);
            bais = this.ZipExcute(is);
        }
        return bais;
    }

    public ByteArrayInputStream ZipExcute(ByteArrayInputStream bytesStream) throws Exception {
        return this.getZipOutputStream(bytesStream);
    }

    public ByteArrayInputStream ZipExcute(String url) throws Exception {
        URL urlAdd = new URL(url);
        InputStream inputStream = urlAdd.openStream();
        return this.ZipExcute(inputStream);
    }

    public ByteArrayInputStream getZipOutputStream(ByteArrayInputStream bais) throws Exception {
        byte[] buf = new byte[2048];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(baos);
        out.putNextEntry(new ZipEntry(ExoExpression.getEntry()));
        if (bais != null && bais.available() != -1) {
            int count;
            while ((count = bais.read(buf)) > 0) {
                out.write(buf, 0, count);
            }
        }
        out.closeEntry();
        out.close();
        bais.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public File getFileToByte(ByteArrayInputStream bais) throws Exception {
        int x;
        File file = new File(this.getDirOut());
        byte[] data = new byte[2048];
        FileOutputStream out = new FileOutputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bais.available());
        while ((x = bais.read(data, 0, 2048)) > 0) {
            baos.write(data, 0, x);
        }
        baos.writeTo(out);
        baos.close();
        bais.close();
        out.close();
        return file;
    }

    public static void setEntry(String entry) {
        entryName = entry;
    }

    public static String getEntry() {
        return entryName;
    }

    public static void setOutFileName(String fileName) {
        outFileName = fileName;
    }

    public static String getOutFileName() {
        return outFileName;
    }

    public static void setPathOut(String dir) {
        pathOut = dir;
    }

    public static String getPathOut() {
        return pathOut;
    }

    public String getDirOut() {
        String dir = ExoExpression.getPathOut() + ExoExpression.getOutFileName() + ".zip";
        return dir;
    }

    public ByteArrayInputStream getZipByteToFolder(File input, boolean containParent) throws Exception {
        String path = input.getAbsolutePath();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zipOutput = new ZipOutputStream(baos);
        BufferedInputStream bufInput = null;
        List<File> list = this.listFile(input);
        if (input.isDirectory()) {
            list.remove(input);
        }
        if (list == null || list.size() < 1) {
            return new ByteArrayInputStream(baos.toByteArray());
        }
        for (File f : list) {
            String filePath = f.getAbsolutePath();
            if (filePath.startsWith(path)) {
                filePath = containParent && input.isDirectory() ? input.getName() + File.separator + filePath.substring(path.length() + 1) : (input.isDirectory() ? filePath.substring(path.length() + 1) : input.getName());
            }
            if (f.isFile()) {
                FileInputStream fileInput = new FileInputStream(f);
                bufInput = new BufferedInputStream(fileInput, 2048);
            } else {
                filePath = filePath + "/";
            }
            this.addToArchive(zipOutput, bufInput, filePath);
            if (bufInput == null) continue;
            bufInput.close();
        }
        zipOutput.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }

    private List<File> listFile(File dir) {
        final ArrayList<File> list = new ArrayList<File>();
        if (dir.isFile()) {
            list.add(dir);
            return list;
        }
        dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    list.addAll(ExoExpression.this.listFile(f));
                }
                list.add(f);
                return true;
            }
        });
        return list;
    }

    public ZipOutputStream addToArchive(ZipOutputStream zipOutput, InputStream input, String entryName1) throws Exception {
        byte[] data = new byte[2048];
        ZipEntry entry = new ZipEntry(entryName1);
        zipOutput.putNextEntry(entry);
        if (input != null) {
            int count;
            while ((count = input.read(data, 0, 2048)) != -1) {
                zipOutput.write(data, 0, count);
            }
        }
        zipOutput.closeEntry();
        return zipOutput;
    }
}

