/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class PrivilegedFileHelper {
    public static FileOutputStream fileOutputStream(final File file) throws FileNotFoundException {
        PrivilegedExceptionAction<FileOutputStream> action = new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws Exception {
                return new FileOutputStream(file);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static ZipOutputStream zipOutputStream(final File file) throws FileNotFoundException {
        PrivilegedExceptionAction<ZipOutputStream> action = new PrivilegedExceptionAction<ZipOutputStream>(){

            @Override
            public ZipOutputStream run() throws Exception {
                return new ZipOutputStream(new FileOutputStream(file));
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static FileOutputStream fileOutputStream(final String name) throws FileNotFoundException {
        PrivilegedExceptionAction<FileOutputStream> action = new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws Exception {
                return new FileOutputStream(name);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static FileOutputStream fileOutputStream(final File file, final boolean append) throws FileNotFoundException {
        PrivilegedExceptionAction<FileOutputStream> action = new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws Exception {
                return new FileOutputStream(file, append);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static FileInputStream fileInputStream(final File file) throws FileNotFoundException {
        PrivilegedExceptionAction<FileInputStream> action = new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                return new FileInputStream(file);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static ZipInputStream zipInputStream(final File file) throws FileNotFoundException {
        PrivilegedExceptionAction<ZipInputStream> action = new PrivilegedExceptionAction<ZipInputStream>(){

            @Override
            public ZipInputStream run() throws Exception {
                return new ZipInputStream(new FileInputStream(file));
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static FileInputStream fileInputStream(final String name) throws FileNotFoundException {
        PrivilegedExceptionAction<FileInputStream> action = new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                return new FileInputStream(name);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static boolean createNewFile(final File file) throws IOException {
        PrivilegedExceptionAction<Boolean> action = new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return file.createNewFile();
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static File createTempFile(final String prefix, final String suffix, final File directory) throws IllegalArgumentException, IOException {
        PrivilegedExceptionAction<File> action = new PrivilegedExceptionAction<File>(){

            @Override
            public File run() throws Exception {
                return File.createTempFile(prefix, suffix, directory);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static File createTempFile(final String prefix, final String suffix) throws IllegalArgumentException, IOException {
        PrivilegedExceptionAction<File> action = new PrivilegedExceptionAction<File>(){

            @Override
            public File run() throws Exception {
                return File.createTempFile(prefix, suffix);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static RandomAccessFile randomAccessFile(final File file, final String mode) throws IllegalArgumentException, IOException {
        PrivilegedExceptionAction<RandomAccessFile> action = new PrivilegedExceptionAction<RandomAccessFile>(){

            @Override
            public RandomAccessFile run() throws Exception {
                return new RandomAccessFile(file, mode);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)cause;
            }
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static long length(final File file) {
        PrivilegedAction<Long> action = new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return new Long(file.length());
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static void deleteOnExit(final File file) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                file.deleteOnExit();
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public static String getAbsolutePath(final File file) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return file.getAbsolutePath();
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static String getCanonicalPath(final File file) throws IOException {
        PrivilegedExceptionAction<String> action = new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return file.getCanonicalPath();
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static boolean delete(final File file) {
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.delete();
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static boolean isDirectory(final File file) {
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory();
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static boolean exists(final File file) {
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static boolean mkdirs(final File file) {
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.mkdirs();
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static boolean renameTo(final File srcFile, final File dstfile) {
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return new Boolean(srcFile.renameTo(dstfile));
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static String[] list(final File file) {
        PrivilegedAction<String[]> action = new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return file.list();
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static String[] list(final File file, final FilenameFilter filter) {
        PrivilegedAction<String[]> action = new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return file.list(filter);
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static File[] listFiles(final File file) {
        PrivilegedAction<File[]> action = new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return file.listFiles();
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static File[] listFiles(final File file, final FilenameFilter filter) {
        PrivilegedAction<File[]> action = new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return file.listFiles(filter);
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static File[] listFiles(final File file, final FileFilter filter) {
        PrivilegedAction<File[]> action = new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return file.listFiles(filter);
            }
        };
        return AccessController.doPrivileged(action);
    }
}

