/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PropertyManager {
    public static final String DEVELOPING = "exo.product.developing";
    public static final String RUNTIME_PROFILES = "exo.profiles";
    public static final String PROPERTIES_URL = "exo.properties.url";
    private static final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();
    private static volatile boolean useCache;
    private static volatile boolean developping;

    public static String getProperty(String propertyName) {
        if (useCache) {
            if (DEVELOPING.equals(propertyName)) {
                return developping ? "true" : "false";
            }
            String propertyValue = (String)cache.get(propertyName);
            if (propertyValue == null && (propertyValue = System.getProperty(propertyName)) != null) {
                cache.put(propertyName, propertyValue);
            }
            return propertyValue;
        }
        return System.getProperty(propertyName);
    }

    public static boolean isDevelopping() {
        if (useCache) {
            return developping;
        }
        return PropertyManager.internalIsDevelopping();
    }

    private static boolean internalIsDevelopping() {
        return "true".equals(System.getProperty(DEVELOPING, "false"));
    }

    public static synchronized void setProperty(String propertyName, String propertyValue) {
        System.setProperty(propertyName, propertyValue);
        cache.remove(propertyName);
        if (DEVELOPING.equals(propertyName)) {
            developping = PropertyManager.internalIsDevelopping();
        }
    }

    public static synchronized boolean getUseCache() {
        return useCache;
    }

    public static synchronized void refresh() {
        useCache = !PropertyManager.internalIsDevelopping();
        developping = PropertyManager.internalIsDevelopping();
        cache.clear();
    }

    static {
        PropertyManager.refresh();
    }
}

