/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.repository;

import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.annotation.security.RolesAllowed;
import javax.jcr.RepositoryException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.repository.NamesList;
import org.exoplatform.services.jcr.ext.repository.RepositoryServiceConf;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/jcr-service")
public class RestRepositoryService
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.RestRepositoryService");
    private final RepositoryService repositoryService;
    private static final CacheControl NO_CACHE = new CacheControl();

    public RestRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/repository-service-configuration")
    public Response getRepositoryServiceConfiguration() {
        RepositoryServiceConfiguration configuration = this.repositoryService.getConfig();
        RepositoryServiceConf conf = new RepositoryServiceConf(configuration.getRepositoryConfigurations(), configuration.getDefaultRepositoryName());
        return Response.ok((Object)((Object)conf), (MediaType)MediaType.APPLICATION_JSON_TYPE).cacheControl(NO_CACHE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/default-ws-config/{repositoryName}")
    public Response getDefaultWorkspaceConfig(@PathParam(value="repositoryName") String repositoryName) {
        Response.Status status;
        String errorMessage = new String();
        try {
            String defaultWorkspaceName = this.repositoryService.getRepository(repositoryName).getConfiguration().getDefaultWorkspaceName();
            for (WorkspaceEntry wEntry : this.repositoryService.getRepository(repositoryName).getConfiguration().getWorkspaceEntries()) {
                if (!defaultWorkspaceName.equals(wEntry.getName())) continue;
                return Response.ok((Object)wEntry).cacheControl(NO_CACHE).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Can not get default workspace configuration.").type("text/plain").cacheControl(NO_CACHE).build();
        }
        catch (RepositoryException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.NOT_FOUND;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)errorMessage).type(MediaType.TEXT_PLAIN_TYPE).cacheControl(NO_CACHE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/create-repository")
    public Response createRepository(@Context UriInfo uriInfo, RepositoryEntry newRepository) throws URISyntaxException {
        Response.Status status;
        String errorMessage = new String();
        try {
            this.repositoryService.createRepository(newRepository);
            this.repositoryService.getConfig().retain();
            return Response.ok().cacheControl(NO_CACHE).build();
        }
        catch (RepositoryException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.BAD_REQUEST;
        }
        catch (RepositoryConfigurationException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.BAD_REQUEST;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)errorMessage).type(MediaType.TEXT_PLAIN_TYPE).cacheControl(NO_CACHE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/create-workspace/{repositoryName}")
    public Response createWorkspace(@Context UriInfo uriInfo, @PathParam(value="repositoryName") String repositoryName, WorkspaceEntry newWorkspace) throws URISyntaxException {
        Response.Status status;
        String errorMessage = new String();
        try {
            RepositoryImpl repository = (RepositoryImpl)this.repositoryService.getRepository(repositoryName);
            repository.configWorkspace(newWorkspace);
            repository.createWorkspace(newWorkspace.getName());
            this.repositoryService.getConfig().retain();
            return Response.ok().cacheControl(NO_CACHE).build();
        }
        catch (RepositoryException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.NOT_FOUND;
        }
        catch (RepositoryConfigurationException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.BAD_REQUEST;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)errorMessage).type(MediaType.TEXT_PLAIN_TYPE).cacheControl(NO_CACHE).build();
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Path(value="/remove-repository/{repositoryName}/{forseSessionClose}")
    public Response removeRepository(@Context UriInfo uriInfo, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="forseSessionClose") Boolean forseSessionClose) {
        Response.Status status;
        String errorMessage = new String();
        try {
            if (forseSessionClose.booleanValue()) {
                for (WorkspaceEntry wsEntry : this.repositoryService.getConfig().getRepositoryConfiguration(repositoryName).getWorkspaceEntries()) {
                    this.forceCloseSession(repositoryName, wsEntry.getName());
                }
            }
            if (this.repositoryService.canRemoveRepository(repositoryName)) {
                this.repositoryService.removeRepository(repositoryName);
                this.repositoryService.getConfig().retain();
                return Response.noContent().build();
            }
            return Response.status((int)409).entity((Object)("Can't remove repository " + repositoryName)).cacheControl(NO_CACHE).build();
        }
        catch (RepositoryException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.NOT_FOUND;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)errorMessage).type(MediaType.TEXT_PLAIN_TYPE).cacheControl(NO_CACHE).build();
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Path(value="/remove-workspace/{repositoryName}/{workspaceName}/{forseSessionClose}/")
    public Response removeWorkspace(@Context UriInfo uriInfo, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="forseSessionClose") Boolean forseSessionClose) {
        Response.Status status;
        String errorMessage = new String();
        try {
            ManageableRepository repository = this.repositoryService.getRepository(repositoryName);
            if (forseSessionClose.booleanValue()) {
                this.forceCloseSession(repositoryName, workspaceName);
            }
            if (repository.canRemoveWorkspace(workspaceName)) {
                repository.removeWorkspace(workspaceName);
                this.repositoryService.getConfig().retain();
                return Response.noContent().build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("Can't remove workspace " + workspaceName + " in repository " + repositoryName)).cacheControl(NO_CACHE).build();
        }
        catch (RepositoryException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.NOT_FOUND;
        }
        catch (RepositoryConfigurationException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.NOT_FOUND;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)errorMessage).type(MediaType.TEXT_PLAIN_TYPE).cacheControl(NO_CACHE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/repositories")
    public Response getRepositoryNames() {
        ArrayList<String> repositories = new ArrayList<String>();
        for (RepositoryEntry rEntry : this.repositoryService.getConfig().getRepositoryConfigurations()) {
            repositories.add(rEntry.getName());
        }
        return Response.ok((Object)new NamesList(repositories)).cacheControl(NO_CACHE).build();
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/workspaces/{repositoryName}")
    public Response getWorkspaceNames(@PathParam(value="repositoryName") String repositoryName) {
        Response.Status status;
        String errorMessage = new String();
        try {
            ArrayList<String> workspaces = new ArrayList<String>();
            for (WorkspaceEntry wEntry : this.repositoryService.getRepository(repositoryName).getConfiguration().getWorkspaceEntries()) {
                workspaces.add(wEntry.getName());
            }
            return Response.ok((Object)new NamesList(workspaces)).cacheControl(NO_CACHE).build();
        }
        catch (RepositoryException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.NOT_FOUND;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), e);
            }
            errorMessage = e.getMessage();
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)errorMessage).type(MediaType.TEXT_PLAIN_TYPE).cacheControl(NO_CACHE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/update-workspace-config/{repositoryName}/{workspaceName}")
    public Response updateWorkspaceConfiguration(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, WorkspaceEntry workspaceEntry) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"The method /update-workspace-config not implemented.").type(MediaType.TEXT_PLAIN_TYPE).cacheControl(NO_CACHE).build();
    }

    private int forceCloseSession(String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository mr = this.repositoryService.getRepository(repositoryName);
        WorkspaceContainerFacade wc = mr.getWorkspaceContainer(workspaceName);
        SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
        return sessionRegistry.closeSessions(workspaceName);
    }

    static {
        NO_CACHE.setNoCache(true);
        NO_CACHE.setNoStore(true);
    }

    public static final class Constants {
        public static final String BASE_URL = "/jcr-service";

        private Constants() {
        }

        public static final class OperationType {
            public static final String REPOSITORY_SERVICE_CONFIGURATION = "/repository-service-configuration";
            public static final String DEFAULT_WS_CONFIG = "/default-ws-config";
            public static final String CREATE_REPOSITORY = "/create-repository";
            public static final String CREATE_WORKSPACE = "/create-workspace";
            public static final String REMOVE_REPOSITORY = "/remove-repository";
            public static final String REMOVE_WORKSPACE = "/remove-workspace";
            public static final String REPOSITORIES_LIST = "/repositories";
            public static final String WORKSPACES_LIST = "/workspaces";
            public static final String UPDATE_WORKSPACE_CONFIG = "/update-workspace-config";

            private OperationType() {
            }
        }
    }
}

