/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test.bandwidth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.replication.test.BaseReplicationTestCase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BandwidthAllocationTestCase
extends BaseReplicationTestCase {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.BandwidthAllocationTestCase");
    private static final String ALPHABET = "qwertyuiop[]asdfghjkl;'zxcvbnm,./1234567890-=!@#$%^&*()_+|:?><";
    private static final int RANDOM_VALUE = 1124517;

    public BandwidthAllocationTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        super(repositoryService, reposytoryName, workspaceName, userName, password);
    }

    public StringBuffer createBaseNode(String repoPath, String nodeName) {
        StringBuffer sb = new StringBuffer();
        try {
            Node baseNode = this.addNodePath(repoPath).addNode(nodeName, "nt:unstructured");
            this.session.save();
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't locked: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer addEmptyNode(String repoPath, String nodeName, long iterations) {
        StringBuffer sb = new StringBuffer();
        try {
            int i = 0;
            while ((long)i < iterations) {
                String normalizePath = this.getNormalizePath(repoPath);
                Node baseNode = (Node)this.session.getItem(normalizePath);
                Node emptyNode = baseNode.addNode(nodeName + "_" + i, "nt:base");
                this.session.save();
                ++i;
            }
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't locked: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer addStringPropertyOnly(String repoPath, String nodeName, Long size, long iterations) {
        StringBuffer sb = new StringBuffer();
        try {
            String sValue = "";
            int i = 0;
            while ((long)i < size) {
                int sIndex = (int)(Math.random() * 1124517.0) % ALPHABET.length();
                sValue = sValue + ALPHABET.substring(sIndex, sIndex + 1);
                ++i;
            }
            i = 0;
            while ((long)i < iterations) {
                String normalizePath = this.getNormalizePath(repoPath);
                Node baseNode = ((Node)this.session.getItem(normalizePath)).getNode(nodeName);
                baseNode.setProperty("d", sValue);
                this.session.save();
                ++i;
            }
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't add the string propery: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringBuffer addBinaryPropertyOnly(String repoPath, String nodeName, Long size, long iterations) {
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[1024];
        File tempFile = null;
        try {
            try {
                tempFile = File.createTempFile("tempF", "_");
                FileOutputStream fos = new FileOutputStream(tempFile);
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = (byte)(i % 255);
                }
                for (long i = 0L; i < size / 1024L; ++i) {
                    fos.write(buf);
                }
                fos.write(buf, 0, (int)(size % 1024L));
                fos.close();
                long start = System.currentTimeMillis();
                int i = 0;
                while ((long)i < iterations) {
                    String normalizePath = this.getNormalizePath(repoPath);
                    Node baseNode = ((Node)this.session.getItem(normalizePath)).getNode(nodeName);
                    baseNode.setProperty("d", (InputStream)new FileInputStream(tempFile));
                    this.session.save();
                    ++i;
                }
                long end = System.currentTimeMillis();
                log.info((Object)("The time of the adding of nt:file + " + iterations + "( " + tempFile.length() + " B ) : " + (double)(end - start) / 1000.0 + " sec"));
                sb.append("ok");
            }
            catch (Exception e) {
                log.error((Object)"Can't save the binary value : ", (Throwable)e);
                sb.append("fail");
                Object var18_18 = null;
                tempFile.delete();
                return sb;
            }
            Object var18_17 = null;
            tempFile.delete();
            return sb;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            tempFile.delete();
            throw throwable;
        }
    }
}

